/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Response;

public class GetFindingsV2Publisher
implements SdkPublisher<GetFindingsV2Response> {
    private final SecurityHubAsyncClient client;
    private final GetFindingsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetFindingsV2Publisher(SecurityHubAsyncClient client, GetFindingsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private GetFindingsV2Publisher(SecurityHubAsyncClient client, GetFindingsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetFindingsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetFindingsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Document> findings() {
        Function<GetFindingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetFindingsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetFindingsV2ResponseFetcher
    implements AsyncPageFetcher<GetFindingsV2Response> {
        private GetFindingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetFindingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetFindingsV2Response> nextPage(GetFindingsV2Response previousPage) {
            if (previousPage == null) {
                return GetFindingsV2Publisher.this.client.getFindingsV2(GetFindingsV2Publisher.this.firstRequest);
            }
            return GetFindingsV2Publisher.this.client.getFindingsV2((GetFindingsV2Request)((Object)GetFindingsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

