/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesCompositeFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcesFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcesFilters> {
    private static final SdkField<List<ResourcesCompositeFilter>> COMPOSITE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CompositeFilters").getter(ResourcesFilters.getter(ResourcesFilters::compositeFilters)).setter(ResourcesFilters.setter(Builder::compositeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesCompositeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPOSITE_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompositeOperator").getter(ResourcesFilters.getter(ResourcesFilters::compositeOperatorAsString)).setter(ResourcesFilters.setter(Builder::compositeOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeOperator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITE_FILTERS_FIELD, COMPOSITE_OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcesFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourcesCompositeFilter> compositeFilters;
    private final String compositeOperator;

    private ResourcesFilters(BuilderImpl builder) {
        this.compositeFilters = builder.compositeFilters;
        this.compositeOperator = builder.compositeOperator;
    }

    public final boolean hasCompositeFilters() {
        return this.compositeFilters != null && !(this.compositeFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesCompositeFilter> compositeFilters() {
        return this.compositeFilters;
    }

    public final AllowedOperators compositeOperator() {
        return AllowedOperators.fromValue(this.compositeOperator);
    }

    public final String compositeOperatorAsString() {
        return this.compositeOperator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeFilters() ? this.compositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeOperatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesFilters)) {
            return false;
        }
        ResourcesFilters other = (ResourcesFilters)obj;
        return this.hasCompositeFilters() == other.hasCompositeFilters() && Objects.equals(this.compositeFilters(), other.compositeFilters()) && Objects.equals(this.compositeOperatorAsString(), other.compositeOperatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcesFilters").add("CompositeFilters", this.hasCompositeFilters() ? this.compositeFilters() : null).add("CompositeOperator", (Object)this.compositeOperatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompositeFilters": {
                return Optional.ofNullable(clazz.cast(this.compositeFilters()));
            }
            case "CompositeOperator": {
                return Optional.ofNullable(clazz.cast(this.compositeOperatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CompositeFilters", COMPOSITE_FILTERS_FIELD);
        map.put("CompositeOperator", COMPOSITE_OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesFilters, T> g) {
        return obj -> g.apply((ResourcesFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcesCompositeFilter> compositeFilters = DefaultSdkAutoConstructList.getInstance();
        private String compositeOperator;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesFilters model) {
            this.compositeFilters(model.compositeFilters);
            this.compositeOperator(model.compositeOperator);
        }

        public final List<ResourcesCompositeFilter.Builder> getCompositeFilters() {
            List<ResourcesCompositeFilter.Builder> result = ResourcesCompositeFilterListCopier.copyToBuilder(this.compositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositeFilters(Collection<ResourcesCompositeFilter.BuilderImpl> compositeFilters) {
            this.compositeFilters = ResourcesCompositeFilterListCopier.copyFromBuilder(compositeFilters);
        }

        @Override
        public final Builder compositeFilters(Collection<ResourcesCompositeFilter> compositeFilters) {
            this.compositeFilters = ResourcesCompositeFilterListCopier.copy(compositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(ResourcesCompositeFilter ... compositeFilters) {
            this.compositeFilters(Arrays.asList(compositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositeFilters(Consumer<ResourcesCompositeFilter.Builder> ... compositeFilters) {
            this.compositeFilters(Stream.of(compositeFilters).map(c -> (ResourcesCompositeFilter)((ResourcesCompositeFilter.Builder)ResourcesCompositeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCompositeOperator() {
            return this.compositeOperator;
        }

        public final void setCompositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
        }

        @Override
        public final Builder compositeOperator(String compositeOperator) {
            this.compositeOperator = compositeOperator;
            return this;
        }

        @Override
        public final Builder compositeOperator(AllowedOperators compositeOperator) {
            this.compositeOperator(compositeOperator == null ? null : compositeOperator.toString());
            return this;
        }

        public ResourcesFilters build() {
            return new ResourcesFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcesFilters> {
        public Builder compositeFilters(Collection<ResourcesCompositeFilter> var1);

        public Builder compositeFilters(ResourcesCompositeFilter ... var1);

        public Builder compositeFilters(Consumer<ResourcesCompositeFilter.Builder> ... var1);

        public Builder compositeOperator(String var1);

        public Builder compositeOperator(AllowedOperators var1);
    }
}

