/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceCategory {
    COMPUTE("Compute"),
    DATABASE("Database"),
    STORAGE("Storage"),
    CODE("Code"),
    AI_ML("AI/ML"),
    IDENTITY("Identity"),
    NETWORK("Network"),
    OTHER("Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceCategory> VALUE_MAP;
    private final String value;

    private ResourceCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceCategory> knownValues() {
        EnumSet<ResourceCategory> knownValues = EnumSet.allOf(ResourceCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceCategory.class, ResourceCategory::toString);
    }
}

