/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityhub.model.JiraCloudDetail;
import software.amazon.awssdk.services.securityhub.model.ServiceNowDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderDetail> {
    private static final SdkField<JiraCloudDetail> JIRA_CLOUD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("JiraCloud").getter(ProviderDetail.getter(ProviderDetail::jiraCloud)).setter(ProviderDetail.setter(Builder::jiraCloud)).constructor(JiraCloudDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraCloud").build()}).build();
    private static final SdkField<ServiceNowDetail> SERVICE_NOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServiceNow").getter(ProviderDetail.getter(ProviderDetail::serviceNow)).setter(ProviderDetail.setter(Builder::serviceNow)).constructor(ServiceNowDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JIRA_CLOUD_FIELD, SERVICE_NOW_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProviderDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final JiraCloudDetail jiraCloud;
    private final ServiceNowDetail serviceNow;
    private final Type type;

    private ProviderDetail(BuilderImpl builder) {
        this.jiraCloud = builder.jiraCloud;
        this.serviceNow = builder.serviceNow;
        this.type = builder.type;
    }

    public final JiraCloudDetail jiraCloud() {
        return this.jiraCloud;
    }

    public final ServiceNowDetail serviceNow() {
        return this.serviceNow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraCloud());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNow());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderDetail)) {
            return false;
        }
        ProviderDetail other = (ProviderDetail)obj;
        return Objects.equals(this.jiraCloud(), other.jiraCloud()) && Objects.equals(this.serviceNow(), other.serviceNow());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderDetail").add("JiraCloud", (Object)this.jiraCloud()).add("ServiceNow", (Object)this.serviceNow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JiraCloud": {
                return Optional.ofNullable(clazz.cast(this.jiraCloud()));
            }
            case "ServiceNow": {
                return Optional.ofNullable(clazz.cast(this.serviceNow()));
            }
        }
        return Optional.empty();
    }

    public static ProviderDetail fromJiraCloud(JiraCloudDetail jiraCloud) {
        return (ProviderDetail)ProviderDetail.builder().jiraCloud(jiraCloud).build();
    }

    public static ProviderDetail fromJiraCloud(Consumer<JiraCloudDetail.Builder> jiraCloud) {
        JiraCloudDetail.Builder builder = JiraCloudDetail.builder();
        jiraCloud.accept(builder);
        return ProviderDetail.fromJiraCloud((JiraCloudDetail)builder.build());
    }

    public static ProviderDetail fromServiceNow(ServiceNowDetail serviceNow) {
        return (ProviderDetail)ProviderDetail.builder().serviceNow(serviceNow).build();
    }

    public static ProviderDetail fromServiceNow(Consumer<ServiceNowDetail.Builder> serviceNow) {
        ServiceNowDetail.Builder builder = ServiceNowDetail.builder();
        serviceNow.accept(builder);
        return ProviderDetail.fromServiceNow((ServiceNowDetail)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JiraCloud", JIRA_CLOUD_FIELD);
        map.put("ServiceNow", SERVICE_NOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderDetail, T> g) {
        return obj -> g.apply((ProviderDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        JIRA_CLOUD,
        SERVICE_NOW,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private JiraCloudDetail jiraCloud;
        private ServiceNowDetail serviceNow;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderDetail model) {
            this.jiraCloud(model.jiraCloud);
            this.serviceNow(model.serviceNow);
        }

        public final JiraCloudDetail.Builder getJiraCloud() {
            return this.jiraCloud != null ? this.jiraCloud.toBuilder() : null;
        }

        public final void setJiraCloud(JiraCloudDetail.BuilderImpl jiraCloud) {
            JiraCloudDetail oldValue = this.jiraCloud;
            this.jiraCloud = jiraCloud != null ? jiraCloud.build() : null;
            this.handleUnionValueChange(Type.JIRA_CLOUD, oldValue, this.jiraCloud);
        }

        @Override
        public final Builder jiraCloud(JiraCloudDetail jiraCloud) {
            JiraCloudDetail oldValue = this.jiraCloud;
            this.jiraCloud = jiraCloud;
            this.handleUnionValueChange(Type.JIRA_CLOUD, oldValue, this.jiraCloud);
            return this;
        }

        public final ServiceNowDetail.Builder getServiceNow() {
            return this.serviceNow != null ? this.serviceNow.toBuilder() : null;
        }

        public final void setServiceNow(ServiceNowDetail.BuilderImpl serviceNow) {
            ServiceNowDetail oldValue = this.serviceNow;
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
            this.handleUnionValueChange(Type.SERVICE_NOW, oldValue, this.serviceNow);
        }

        @Override
        public final Builder serviceNow(ServiceNowDetail serviceNow) {
            ServiceNowDetail oldValue = this.serviceNow;
            this.serviceNow = serviceNow;
            this.handleUnionValueChange(Type.SERVICE_NOW, oldValue, this.serviceNow);
            return this;
        }

        public ProviderDetail build() {
            return new ProviderDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderDetail> {
        public Builder jiraCloud(JiraCloudDetail var1);

        default public Builder jiraCloud(Consumer<JiraCloudDetail.Builder> jiraCloud) {
            return this.jiraCloud((JiraCloudDetail)((JiraCloudDetail.Builder)JiraCloudDetail.builder().applyMutation(jiraCloud)).build());
        }

        public Builder serviceNow(ServiceNowDetail var1);

        default public Builder serviceNow(Consumer<ServiceNowDetail.Builder> serviceNow) {
            return this.serviceNow((ServiceNowDetail)((ServiceNowDetail.Builder)ServiceNowDetail.builder().applyMutation(serviceNow)).build());
        }
    }
}

