/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.GroupByField;
import software.amazon.awssdk.services.securityhub.model.OcsfFindingFilters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupByRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupByRule> {
    private static final SdkField<OcsfFindingFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GroupByRule.getter(GroupByRule::filters)).setter(GroupByRule.setter(Builder::filters)).constructor(OcsfFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> GROUP_BY_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByField").getter(GroupByRule.getter(GroupByRule::groupByFieldAsString)).setter(GroupByRule.setter(Builder::groupByField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, GROUP_BY_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupByRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OcsfFindingFilters filters;
    private final String groupByField;

    private GroupByRule(BuilderImpl builder) {
        this.filters = builder.filters;
        this.groupByField = builder.groupByField;
    }

    public final OcsfFindingFilters filters() {
        return this.filters;
    }

    public final GroupByField groupByField() {
        return GroupByField.fromValue(this.groupByField);
    }

    public final String groupByFieldAsString() {
        return this.groupByField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByFieldAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupByRule)) {
            return false;
        }
        GroupByRule other = (GroupByRule)obj;
        return Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupByFieldAsString(), other.groupByFieldAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GroupByRule").add("Filters", (Object)this.filters()).add("GroupByField", (Object)this.groupByFieldAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "GroupByField": {
                return Optional.ofNullable(clazz.cast(this.groupByFieldAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filters", FILTERS_FIELD);
        map.put("GroupByField", GROUP_BY_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupByRule, T> g) {
        return obj -> g.apply((GroupByRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OcsfFindingFilters filters;
        private String groupByField;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupByRule model) {
            this.filters(model.filters);
            this.groupByField(model.groupByField);
        }

        public final OcsfFindingFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(OcsfFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(OcsfFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getGroupByField() {
            return this.groupByField;
        }

        public final void setGroupByField(String groupByField) {
            this.groupByField = groupByField;
        }

        @Override
        public final Builder groupByField(String groupByField) {
            this.groupByField = groupByField;
            return this;
        }

        @Override
        public final Builder groupByField(GroupByField groupByField) {
            this.groupByField(groupByField == null ? null : groupByField.toString());
            return this;
        }

        public GroupByRule build() {
            return new GroupByRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupByRule> {
        public Builder filters(OcsfFindingFilters var1);

        default public Builder filters(Consumer<OcsfFindingFilters.Builder> filters) {
            return this.filters((OcsfFindingFilters)((OcsfFindingFilters.Builder)OcsfFindingFilters.builder().applyMutation(filters)).build());
        }

        public Builder groupByField(String var1);

        public Builder groupByField(GroupByField var1);
    }
}

