/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAggregatorV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetAggregatorV2Response> {
    private static final SdkField<String> AGGREGATOR_V2_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregatorV2Arn").getter(GetAggregatorV2Response.getter(GetAggregatorV2Response::aggregatorV2Arn)).setter(GetAggregatorV2Response.setter(Builder::aggregatorV2Arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregatorV2Arn").build()}).build();
    private static final SdkField<String> AGGREGATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationRegion").getter(GetAggregatorV2Response.getter(GetAggregatorV2Response::aggregationRegion)).setter(GetAggregatorV2Response.setter(Builder::aggregationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationRegion").build()}).build();
    private static final SdkField<String> REGION_LINKING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionLinkingMode").getter(GetAggregatorV2Response.getter(GetAggregatorV2Response::regionLinkingMode)).setter(GetAggregatorV2Response.setter(Builder::regionLinkingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionLinkingMode").build()}).build();
    private static final SdkField<List<String>> LINKED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LinkedRegions").getter(GetAggregatorV2Response.getter(GetAggregatorV2Response::linkedRegions)).setter(GetAggregatorV2Response.setter(Builder::linkedRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkedRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATOR_V2_ARN_FIELD, AGGREGATION_REGION_FIELD, REGION_LINKING_MODE_FIELD, LINKED_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAggregatorV2Response.memberNameToFieldInitializer();
    private final String aggregatorV2Arn;
    private final String aggregationRegion;
    private final String regionLinkingMode;
    private final List<String> linkedRegions;

    private GetAggregatorV2Response(BuilderImpl builder) {
        super(builder);
        this.aggregatorV2Arn = builder.aggregatorV2Arn;
        this.aggregationRegion = builder.aggregationRegion;
        this.regionLinkingMode = builder.regionLinkingMode;
        this.linkedRegions = builder.linkedRegions;
    }

    public final String aggregatorV2Arn() {
        return this.aggregatorV2Arn;
    }

    public final String aggregationRegion() {
        return this.aggregationRegion;
    }

    public final String regionLinkingMode() {
        return this.regionLinkingMode;
    }

    public final boolean hasLinkedRegions() {
        return this.linkedRegions != null && !(this.linkedRegions instanceof SdkAutoConstructList);
    }

    public final List<String> linkedRegions() {
        return this.linkedRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregatorV2Arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionLinkingMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinkedRegions() ? this.linkedRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAggregatorV2Response)) {
            return false;
        }
        GetAggregatorV2Response other = (GetAggregatorV2Response)((Object)obj);
        return Objects.equals(this.aggregatorV2Arn(), other.aggregatorV2Arn()) && Objects.equals(this.aggregationRegion(), other.aggregationRegion()) && Objects.equals(this.regionLinkingMode(), other.regionLinkingMode()) && this.hasLinkedRegions() == other.hasLinkedRegions() && Objects.equals(this.linkedRegions(), other.linkedRegions());
    }

    public final String toString() {
        return ToString.builder((String)"GetAggregatorV2Response").add("AggregatorV2Arn", (Object)this.aggregatorV2Arn()).add("AggregationRegion", (Object)this.aggregationRegion()).add("RegionLinkingMode", (Object)this.regionLinkingMode()).add("LinkedRegions", this.hasLinkedRegions() ? this.linkedRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AggregatorV2Arn": {
                return Optional.ofNullable(clazz.cast(this.aggregatorV2Arn()));
            }
            case "AggregationRegion": {
                return Optional.ofNullable(clazz.cast(this.aggregationRegion()));
            }
            case "RegionLinkingMode": {
                return Optional.ofNullable(clazz.cast(this.regionLinkingMode()));
            }
            case "LinkedRegions": {
                return Optional.ofNullable(clazz.cast(this.linkedRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AggregatorV2Arn", AGGREGATOR_V2_ARN_FIELD);
        map.put("AggregationRegion", AGGREGATION_REGION_FIELD);
        map.put("RegionLinkingMode", REGION_LINKING_MODE_FIELD);
        map.put("LinkedRegions", LINKED_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAggregatorV2Response, T> g) {
        return obj -> g.apply((GetAggregatorV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String aggregatorV2Arn;
        private String aggregationRegion;
        private String regionLinkingMode;
        private List<String> linkedRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAggregatorV2Response model) {
            super(model);
            this.aggregatorV2Arn(model.aggregatorV2Arn);
            this.aggregationRegion(model.aggregationRegion);
            this.regionLinkingMode(model.regionLinkingMode);
            this.linkedRegions(model.linkedRegions);
        }

        public final String getAggregatorV2Arn() {
            return this.aggregatorV2Arn;
        }

        public final void setAggregatorV2Arn(String aggregatorV2Arn) {
            this.aggregatorV2Arn = aggregatorV2Arn;
        }

        @Override
        public final Builder aggregatorV2Arn(String aggregatorV2Arn) {
            this.aggregatorV2Arn = aggregatorV2Arn;
            return this;
        }

        public final String getAggregationRegion() {
            return this.aggregationRegion;
        }

        public final void setAggregationRegion(String aggregationRegion) {
            this.aggregationRegion = aggregationRegion;
        }

        @Override
        public final Builder aggregationRegion(String aggregationRegion) {
            this.aggregationRegion = aggregationRegion;
            return this;
        }

        public final String getRegionLinkingMode() {
            return this.regionLinkingMode;
        }

        public final void setRegionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
        }

        @Override
        public final Builder regionLinkingMode(String regionLinkingMode) {
            this.regionLinkingMode = regionLinkingMode;
            return this;
        }

        public final Collection<String> getLinkedRegions() {
            if (this.linkedRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.linkedRegions;
        }

        public final void setLinkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
        }

        @Override
        public final Builder linkedRegions(Collection<String> linkedRegions) {
            this.linkedRegions = StringListCopier.copy(linkedRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkedRegions(String ... linkedRegions) {
            this.linkedRegions(Arrays.asList(linkedRegions));
            return this;
        }

        @Override
        public GetAggregatorV2Response build() {
            return new GetAggregatorV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAggregatorV2Response> {
        public Builder aggregatorV2Arn(String var1);

        public Builder aggregationRegion(String var1);

        public Builder regionLinkingMode(String var1);

        public Builder linkedRegions(Collection<String> var1);

        public Builder linkedRegions(String ... var1);
    }
}

