/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComplianceStatus {
    PASSED("PASSED"),
    WARNING("WARNING"),
    FAILED("FAILED"),
    NOT_AVAILABLE("NOT_AVAILABLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComplianceStatus> VALUE_MAP;
    private final String value;

    private ComplianceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComplianceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComplianceStatus> knownValues() {
        EnumSet<ComplianceStatus> knownValues = EnumSet.allOf(ComplianceStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComplianceStatus.class, ComplianceStatus::toString);
    }
}

