/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.MetadataUidListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifier;
import software.amazon.awssdk.services.securityhub.model.OcsfFindingIdentifierListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateFindingsV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, BatchUpdateFindingsV2Request> {
    private static final SdkField<List<String>> METADATA_UIDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetadataUids").getter(BatchUpdateFindingsV2Request.getter(BatchUpdateFindingsV2Request::metadataUids)).setter(BatchUpdateFindingsV2Request.setter(Builder::metadataUids)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataUids").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfFindingIdentifier>> FINDING_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingIdentifiers").getter(BatchUpdateFindingsV2Request.getter(BatchUpdateFindingsV2Request::findingIdentifiers)).setter(BatchUpdateFindingsV2Request.setter(Builder::findingIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfFindingIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(BatchUpdateFindingsV2Request.getter(BatchUpdateFindingsV2Request::comment)).setter(BatchUpdateFindingsV2Request.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<Integer> SEVERITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SeverityId").getter(BatchUpdateFindingsV2Request.getter(BatchUpdateFindingsV2Request::severityId)).setter(BatchUpdateFindingsV2Request.setter(Builder::severityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityId").build()}).build();
    private static final SdkField<Integer> STATUS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StatusId").getter(BatchUpdateFindingsV2Request.getter(BatchUpdateFindingsV2Request::statusId)).setter(BatchUpdateFindingsV2Request.setter(Builder::statusId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_UIDS_FIELD, FINDING_IDENTIFIERS_FIELD, COMMENT_FIELD, SEVERITY_ID_FIELD, STATUS_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateFindingsV2Request.memberNameToFieldInitializer();
    private final List<String> metadataUids;
    private final List<OcsfFindingIdentifier> findingIdentifiers;
    private final String comment;
    private final Integer severityId;
    private final Integer statusId;

    private BatchUpdateFindingsV2Request(BuilderImpl builder) {
        super(builder);
        this.metadataUids = builder.metadataUids;
        this.findingIdentifiers = builder.findingIdentifiers;
        this.comment = builder.comment;
        this.severityId = builder.severityId;
        this.statusId = builder.statusId;
    }

    public final boolean hasMetadataUids() {
        return this.metadataUids != null && !(this.metadataUids instanceof SdkAutoConstructList);
    }

    public final List<String> metadataUids() {
        return this.metadataUids;
    }

    public final boolean hasFindingIdentifiers() {
        return this.findingIdentifiers != null && !(this.findingIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<OcsfFindingIdentifier> findingIdentifiers() {
        return this.findingIdentifiers;
    }

    public final String comment() {
        return this.comment;
    }

    public final Integer severityId() {
        return this.severityId;
    }

    public final Integer statusId() {
        return this.statusId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataUids() ? this.metadataUids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingIdentifiers() ? this.findingIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFindingsV2Request)) {
            return false;
        }
        BatchUpdateFindingsV2Request other = (BatchUpdateFindingsV2Request)((Object)obj);
        return this.hasMetadataUids() == other.hasMetadataUids() && Objects.equals(this.metadataUids(), other.metadataUids()) && this.hasFindingIdentifiers() == other.hasFindingIdentifiers() && Objects.equals(this.findingIdentifiers(), other.findingIdentifiers()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.severityId(), other.severityId()) && Objects.equals(this.statusId(), other.statusId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateFindingsV2Request").add("MetadataUids", this.hasMetadataUids() ? this.metadataUids() : null).add("FindingIdentifiers", this.hasFindingIdentifiers() ? this.findingIdentifiers() : null).add("Comment", (Object)this.comment()).add("SeverityId", (Object)this.severityId()).add("StatusId", (Object)this.statusId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataUids": {
                return Optional.ofNullable(clazz.cast(this.metadataUids()));
            }
            case "FindingIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.findingIdentifiers()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "SeverityId": {
                return Optional.ofNullable(clazz.cast(this.severityId()));
            }
            case "StatusId": {
                return Optional.ofNullable(clazz.cast(this.statusId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetadataUids", METADATA_UIDS_FIELD);
        map.put("FindingIdentifiers", FINDING_IDENTIFIERS_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("SeverityId", SEVERITY_ID_FIELD);
        map.put("StatusId", STATUS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFindingsV2Request, T> g) {
        return obj -> g.apply((BatchUpdateFindingsV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private List<String> metadataUids = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfFindingIdentifier> findingIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private String comment;
        private Integer severityId;
        private Integer statusId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFindingsV2Request model) {
            super(model);
            this.metadataUids(model.metadataUids);
            this.findingIdentifiers(model.findingIdentifiers);
            this.comment(model.comment);
            this.severityId(model.severityId);
            this.statusId(model.statusId);
        }

        public final Collection<String> getMetadataUids() {
            if (this.metadataUids instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadataUids;
        }

        public final void setMetadataUids(Collection<String> metadataUids) {
            this.metadataUids = MetadataUidListCopier.copy(metadataUids);
        }

        @Override
        public final Builder metadataUids(Collection<String> metadataUids) {
            this.metadataUids = MetadataUidListCopier.copy(metadataUids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataUids(String ... metadataUids) {
            this.metadataUids(Arrays.asList(metadataUids));
            return this;
        }

        public final List<OcsfFindingIdentifier.Builder> getFindingIdentifiers() {
            List<OcsfFindingIdentifier.Builder> result = OcsfFindingIdentifierListCopier.copyToBuilder(this.findingIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFindingIdentifiers(Collection<OcsfFindingIdentifier.BuilderImpl> findingIdentifiers) {
            this.findingIdentifiers = OcsfFindingIdentifierListCopier.copyFromBuilder(findingIdentifiers);
        }

        @Override
        public final Builder findingIdentifiers(Collection<OcsfFindingIdentifier> findingIdentifiers) {
            this.findingIdentifiers = OcsfFindingIdentifierListCopier.copy(findingIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(OcsfFindingIdentifier ... findingIdentifiers) {
            this.findingIdentifiers(Arrays.asList(findingIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingIdentifiers(Consumer<OcsfFindingIdentifier.Builder> ... findingIdentifiers) {
            this.findingIdentifiers(Stream.of(findingIdentifiers).map(c -> (OcsfFindingIdentifier)((OcsfFindingIdentifier.Builder)OcsfFindingIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Integer getSeverityId() {
            return this.severityId;
        }

        public final void setSeverityId(Integer severityId) {
            this.severityId = severityId;
        }

        @Override
        public final Builder severityId(Integer severityId) {
            this.severityId = severityId;
            return this;
        }

        public final Integer getStatusId() {
            return this.statusId;
        }

        public final void setStatusId(Integer statusId) {
            this.statusId = statusId;
        }

        @Override
        public final Builder statusId(Integer statusId) {
            this.statusId = statusId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFindingsV2Request build() {
            return new BatchUpdateFindingsV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateFindingsV2Request> {
        public Builder metadataUids(Collection<String> var1);

        public Builder metadataUids(String ... var1);

        public Builder findingIdentifiers(Collection<OcsfFindingIdentifier> var1);

        public Builder findingIdentifiers(OcsfFindingIdentifier ... var1);

        public Builder findingIdentifiers(Consumer<OcsfFindingIdentifier.Builder> ... var1);

        public Builder comment(String var1);

        public Builder severityId(Integer var1);

        public Builder statusId(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

