/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroup;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupEc2SecurityGroupsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRange;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbSecurityGroupIpRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbSecurityGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbSecurityGroupDetails> {
    private static final SdkField<String> DB_SECURITY_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSecurityGroupArn").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::dbSecurityGroupArn)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::dbSecurityGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSecurityGroupArn").build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSecurityGroupDescription").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::dbSecurityGroupDescription)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::dbSecurityGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSecurityGroupDescription").build()}).build();
    private static final SdkField<String> DB_SECURITY_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSecurityGroupName").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::dbSecurityGroupName)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::dbSecurityGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSecurityGroupName").build()}).build();
    private static final SdkField<List<AwsRdsDbSecurityGroupEc2SecurityGroup>> EC2_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ec2SecurityGroups").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::ec2SecurityGroups)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::ec2SecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbSecurityGroupEc2SecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsRdsDbSecurityGroupIpRange>> IP_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpRanges").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::ipRanges)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::ipRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbSecurityGroupIpRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::ownerId)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(AwsRdsDbSecurityGroupDetails.getter(AwsRdsDbSecurityGroupDetails::vpcId)).setter(AwsRdsDbSecurityGroupDetails.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SECURITY_GROUP_ARN_FIELD, DB_SECURITY_GROUP_DESCRIPTION_FIELD, DB_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUPS_FIELD, IP_RANGES_FIELD, OWNER_ID_FIELD, VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsRdsDbSecurityGroupDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbSecurityGroupArn;
    private final String dbSecurityGroupDescription;
    private final String dbSecurityGroupName;
    private final List<AwsRdsDbSecurityGroupEc2SecurityGroup> ec2SecurityGroups;
    private final List<AwsRdsDbSecurityGroupIpRange> ipRanges;
    private final String ownerId;
    private final String vpcId;

    private AwsRdsDbSecurityGroupDetails(BuilderImpl builder) {
        this.dbSecurityGroupArn = builder.dbSecurityGroupArn;
        this.dbSecurityGroupDescription = builder.dbSecurityGroupDescription;
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.ec2SecurityGroups = builder.ec2SecurityGroups;
        this.ipRanges = builder.ipRanges;
        this.ownerId = builder.ownerId;
        this.vpcId = builder.vpcId;
    }

    public final String dbSecurityGroupArn() {
        return this.dbSecurityGroupArn;
    }

    public final String dbSecurityGroupDescription() {
        return this.dbSecurityGroupDescription;
    }

    public final String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public final boolean hasEc2SecurityGroups() {
        return this.ec2SecurityGroups != null && !(this.ec2SecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbSecurityGroupEc2SecurityGroup> ec2SecurityGroups() {
        return this.ec2SecurityGroups;
    }

    public final boolean hasIpRanges() {
        return this.ipRanges != null && !(this.ipRanges instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbSecurityGroupIpRange> ipRanges() {
        return this.ipRanges;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpRanges() ? this.ipRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSecurityGroupDetails)) {
            return false;
        }
        AwsRdsDbSecurityGroupDetails other = (AwsRdsDbSecurityGroupDetails)obj;
        return Objects.equals(this.dbSecurityGroupArn(), other.dbSecurityGroupArn()) && Objects.equals(this.dbSecurityGroupDescription(), other.dbSecurityGroupDescription()) && Objects.equals(this.dbSecurityGroupName(), other.dbSecurityGroupName()) && this.hasEc2SecurityGroups() == other.hasEc2SecurityGroups() && Objects.equals(this.ec2SecurityGroups(), other.ec2SecurityGroups()) && this.hasIpRanges() == other.hasIpRanges() && Objects.equals(this.ipRanges(), other.ipRanges()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.vpcId(), other.vpcId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRdsDbSecurityGroupDetails").add("DbSecurityGroupArn", (Object)this.dbSecurityGroupArn()).add("DbSecurityGroupDescription", (Object)this.dbSecurityGroupDescription()).add("DbSecurityGroupName", (Object)this.dbSecurityGroupName()).add("Ec2SecurityGroups", this.hasEc2SecurityGroups() ? this.ec2SecurityGroups() : null).add("IpRanges", this.hasIpRanges() ? this.ipRanges() : null).add("OwnerId", (Object)this.ownerId()).add("VpcId", (Object)this.vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DbSecurityGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupArn()));
            }
            case "DbSecurityGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupDescription()));
            }
            case "DbSecurityGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupName()));
            }
            case "Ec2SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.ec2SecurityGroups()));
            }
            case "IpRanges": {
                return Optional.ofNullable(clazz.cast(this.ipRanges()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DbSecurityGroupArn", DB_SECURITY_GROUP_ARN_FIELD);
        map.put("DbSecurityGroupDescription", DB_SECURITY_GROUP_DESCRIPTION_FIELD);
        map.put("DbSecurityGroupName", DB_SECURITY_GROUP_NAME_FIELD);
        map.put("Ec2SecurityGroups", EC2_SECURITY_GROUPS_FIELD);
        map.put("IpRanges", IP_RANGES_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSecurityGroupDetails, T> g) {
        return obj -> g.apply((AwsRdsDbSecurityGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbSecurityGroupArn;
        private String dbSecurityGroupDescription;
        private String dbSecurityGroupName;
        private List<AwsRdsDbSecurityGroupEc2SecurityGroup> ec2SecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<AwsRdsDbSecurityGroupIpRange> ipRanges = DefaultSdkAutoConstructList.getInstance();
        private String ownerId;
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSecurityGroupDetails model) {
            this.dbSecurityGroupArn(model.dbSecurityGroupArn);
            this.dbSecurityGroupDescription(model.dbSecurityGroupDescription);
            this.dbSecurityGroupName(model.dbSecurityGroupName);
            this.ec2SecurityGroups(model.ec2SecurityGroups);
            this.ipRanges(model.ipRanges);
            this.ownerId(model.ownerId);
            this.vpcId(model.vpcId);
        }

        public final String getDbSecurityGroupArn() {
            return this.dbSecurityGroupArn;
        }

        public final void setDbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
        }

        @Override
        public final Builder dbSecurityGroupArn(String dbSecurityGroupArn) {
            this.dbSecurityGroupArn = dbSecurityGroupArn;
            return this;
        }

        public final String getDbSecurityGroupDescription() {
            return this.dbSecurityGroupDescription;
        }

        public final void setDbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
        }

        @Override
        public final Builder dbSecurityGroupDescription(String dbSecurityGroupDescription) {
            this.dbSecurityGroupDescription = dbSecurityGroupDescription;
            return this;
        }

        public final String getDbSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        public final void setDbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final List<AwsRdsDbSecurityGroupEc2SecurityGroup.Builder> getEc2SecurityGroups() {
            List<AwsRdsDbSecurityGroupEc2SecurityGroup.Builder> result = AwsRdsDbSecurityGroupEc2SecurityGroupsCopier.copyToBuilder(this.ec2SecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2SecurityGroups(Collection<AwsRdsDbSecurityGroupEc2SecurityGroup.BuilderImpl> ec2SecurityGroups) {
            this.ec2SecurityGroups = AwsRdsDbSecurityGroupEc2SecurityGroupsCopier.copyFromBuilder(ec2SecurityGroups);
        }

        @Override
        public final Builder ec2SecurityGroups(Collection<AwsRdsDbSecurityGroupEc2SecurityGroup> ec2SecurityGroups) {
            this.ec2SecurityGroups = AwsRdsDbSecurityGroupEc2SecurityGroupsCopier.copy(ec2SecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(AwsRdsDbSecurityGroupEc2SecurityGroup ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Arrays.asList(ec2SecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SecurityGroups(Consumer<AwsRdsDbSecurityGroupEc2SecurityGroup.Builder> ... ec2SecurityGroups) {
            this.ec2SecurityGroups(Stream.of(ec2SecurityGroups).map(c -> (AwsRdsDbSecurityGroupEc2SecurityGroup)((AwsRdsDbSecurityGroupEc2SecurityGroup.Builder)AwsRdsDbSecurityGroupEc2SecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsRdsDbSecurityGroupIpRange.Builder> getIpRanges() {
            List<AwsRdsDbSecurityGroupIpRange.Builder> result = AwsRdsDbSecurityGroupIpRangesCopier.copyToBuilder(this.ipRanges);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRanges(Collection<AwsRdsDbSecurityGroupIpRange.BuilderImpl> ipRanges) {
            this.ipRanges = AwsRdsDbSecurityGroupIpRangesCopier.copyFromBuilder(ipRanges);
        }

        @Override
        public final Builder ipRanges(Collection<AwsRdsDbSecurityGroupIpRange> ipRanges) {
            this.ipRanges = AwsRdsDbSecurityGroupIpRangesCopier.copy(ipRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(AwsRdsDbSecurityGroupIpRange ... ipRanges) {
            this.ipRanges(Arrays.asList(ipRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRanges(Consumer<AwsRdsDbSecurityGroupIpRange.Builder> ... ipRanges) {
            this.ipRanges(Stream.of(ipRanges).map(c -> (AwsRdsDbSecurityGroupIpRange)((AwsRdsDbSecurityGroupIpRange.Builder)AwsRdsDbSecurityGroupIpRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public AwsRdsDbSecurityGroupDetails build() {
            return new AwsRdsDbSecurityGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbSecurityGroupDetails> {
        public Builder dbSecurityGroupArn(String var1);

        public Builder dbSecurityGroupDescription(String var1);

        public Builder dbSecurityGroupName(String var1);

        public Builder ec2SecurityGroups(Collection<AwsRdsDbSecurityGroupEc2SecurityGroup> var1);

        public Builder ec2SecurityGroups(AwsRdsDbSecurityGroupEc2SecurityGroup ... var1);

        public Builder ec2SecurityGroups(Consumer<AwsRdsDbSecurityGroupEc2SecurityGroup.Builder> ... var1);

        public Builder ipRanges(Collection<AwsRdsDbSecurityGroupIpRange> var1);

        public Builder ipRanges(AwsRdsDbSecurityGroupIpRange ... var1);

        public Builder ipRanges(Consumer<AwsRdsDbSecurityGroupIpRange.Builder> ... var1);

        public Builder ownerId(String var1);

        public Builder vpcId(String var1);
    }
}

