/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanAdvancedBackupSettingsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleDetails;
import software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanRuleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsBackupBackupPlanBackupPlanDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsBackupBackupPlanBackupPlanDetails> {
    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupPlanName").getter(AwsBackupBackupPlanBackupPlanDetails.getter(AwsBackupBackupPlanBackupPlanDetails::backupPlanName)).setter(AwsBackupBackupPlanBackupPlanDetails.setter(Builder::backupPlanName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()}).build();
    private static final SdkField<List<AwsBackupBackupPlanAdvancedBackupSettingsDetails>> ADVANCED_BACKUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdvancedBackupSettings").getter(AwsBackupBackupPlanBackupPlanDetails.getter(AwsBackupBackupPlanBackupPlanDetails::advancedBackupSettings)).setter(AwsBackupBackupPlanBackupPlanDetails.setter(Builder::advancedBackupSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedBackupSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsBackupBackupPlanAdvancedBackupSettingsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsBackupBackupPlanRuleDetails>> BACKUP_PLAN_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BackupPlanRule").getter(AwsBackupBackupPlanBackupPlanDetails.getter(AwsBackupBackupPlanBackupPlanDetails::backupPlanRule)).setter(AwsBackupBackupPlanBackupPlanDetails.setter(Builder::backupPlanRule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanRule").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsBackupBackupPlanRuleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_NAME_FIELD, ADVANCED_BACKUP_SETTINGS_FIELD, BACKUP_PLAN_RULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsBackupBackupPlanBackupPlanDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String backupPlanName;
    private final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings;
    private final List<AwsBackupBackupPlanRuleDetails> backupPlanRule;

    private AwsBackupBackupPlanBackupPlanDetails(BuilderImpl builder) {
        this.backupPlanName = builder.backupPlanName;
        this.advancedBackupSettings = builder.advancedBackupSettings;
        this.backupPlanRule = builder.backupPlanRule;
    }

    public final String backupPlanName() {
        return this.backupPlanName;
    }

    public final boolean hasAdvancedBackupSettings() {
        return this.advancedBackupSettings != null && !(this.advancedBackupSettings instanceof SdkAutoConstructList);
    }

    public final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings() {
        return this.advancedBackupSettings;
    }

    public final boolean hasBackupPlanRule() {
        return this.backupPlanRule != null && !(this.backupPlanRule instanceof SdkAutoConstructList);
    }

    public final List<AwsBackupBackupPlanRuleDetails> backupPlanRule() {
        return this.backupPlanRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBackupPlanRule() ? this.backupPlanRule() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanBackupPlanDetails)) {
            return false;
        }
        AwsBackupBackupPlanBackupPlanDetails other = (AwsBackupBackupPlanBackupPlanDetails)obj;
        return Objects.equals(this.backupPlanName(), other.backupPlanName()) && this.hasAdvancedBackupSettings() == other.hasAdvancedBackupSettings() && Objects.equals(this.advancedBackupSettings(), other.advancedBackupSettings()) && this.hasBackupPlanRule() == other.hasBackupPlanRule() && Objects.equals(this.backupPlanRule(), other.backupPlanRule());
    }

    public final String toString() {
        return ToString.builder((String)"AwsBackupBackupPlanBackupPlanDetails").add("BackupPlanName", (Object)this.backupPlanName()).add("AdvancedBackupSettings", this.hasAdvancedBackupSettings() ? this.advancedBackupSettings() : null).add("BackupPlanRule", this.hasBackupPlanRule() ? this.backupPlanRule() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupPlanName": {
                return Optional.ofNullable(clazz.cast(this.backupPlanName()));
            }
            case "AdvancedBackupSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedBackupSettings()));
            }
            case "BackupPlanRule": {
                return Optional.ofNullable(clazz.cast(this.backupPlanRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("BackupPlanName", BACKUP_PLAN_NAME_FIELD);
        map.put("AdvancedBackupSettings", ADVANCED_BACKUP_SETTINGS_FIELD);
        map.put("BackupPlanRule", BACKUP_PLAN_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanBackupPlanDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanBackupPlanDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String backupPlanName;
        private List<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings = DefaultSdkAutoConstructList.getInstance();
        private List<AwsBackupBackupPlanRuleDetails> backupPlanRule = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanBackupPlanDetails model) {
            this.backupPlanName(model.backupPlanName);
            this.advancedBackupSettings(model.advancedBackupSettings);
            this.backupPlanRule(model.backupPlanRule);
        }

        public final String getBackupPlanName() {
            return this.backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final List<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> getAdvancedBackupSettings() {
            List<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> result = AwsBackupBackupPlanAdvancedBackupSettingsListCopier.copyToBuilder(this.advancedBackupSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedBackupSettings(Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails.BuilderImpl> advancedBackupSettings) {
            this.advancedBackupSettings = AwsBackupBackupPlanAdvancedBackupSettingsListCopier.copyFromBuilder(advancedBackupSettings);
        }

        @Override
        public final Builder advancedBackupSettings(Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails> advancedBackupSettings) {
            this.advancedBackupSettings = AwsBackupBackupPlanAdvancedBackupSettingsListCopier.copy(advancedBackupSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(AwsBackupBackupPlanAdvancedBackupSettingsDetails ... advancedBackupSettings) {
            this.advancedBackupSettings(Arrays.asList(advancedBackupSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedBackupSettings(Consumer<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> ... advancedBackupSettings) {
            this.advancedBackupSettings(Stream.of(advancedBackupSettings).map(c -> (AwsBackupBackupPlanAdvancedBackupSettingsDetails)((AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder)AwsBackupBackupPlanAdvancedBackupSettingsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AwsBackupBackupPlanRuleDetails.Builder> getBackupPlanRule() {
            List<AwsBackupBackupPlanRuleDetails.Builder> result = AwsBackupBackupPlanRuleListCopier.copyToBuilder(this.backupPlanRule);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBackupPlanRule(Collection<AwsBackupBackupPlanRuleDetails.BuilderImpl> backupPlanRule) {
            this.backupPlanRule = AwsBackupBackupPlanRuleListCopier.copyFromBuilder(backupPlanRule);
        }

        @Override
        public final Builder backupPlanRule(Collection<AwsBackupBackupPlanRuleDetails> backupPlanRule) {
            this.backupPlanRule = AwsBackupBackupPlanRuleListCopier.copy(backupPlanRule);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanRule(AwsBackupBackupPlanRuleDetails ... backupPlanRule) {
            this.backupPlanRule(Arrays.asList(backupPlanRule));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder backupPlanRule(Consumer<AwsBackupBackupPlanRuleDetails.Builder> ... backupPlanRule) {
            this.backupPlanRule(Stream.of(backupPlanRule).map(c -> (AwsBackupBackupPlanRuleDetails)((AwsBackupBackupPlanRuleDetails.Builder)AwsBackupBackupPlanRuleDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsBackupBackupPlanBackupPlanDetails build() {
            return new AwsBackupBackupPlanBackupPlanDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsBackupBackupPlanBackupPlanDetails> {
        public Builder backupPlanName(String var1);

        public Builder advancedBackupSettings(Collection<AwsBackupBackupPlanAdvancedBackupSettingsDetails> var1);

        public Builder advancedBackupSettings(AwsBackupBackupPlanAdvancedBackupSettingsDetails ... var1);

        public Builder advancedBackupSettings(Consumer<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder> ... var1);

        public Builder backupPlanRule(Collection<AwsBackupBackupPlanRuleDetails> var1);

        public Builder backupPlanRule(AwsBackupBackupPlanRuleDetails ... var1);

        public Builder backupPlanRule(Consumer<AwsBackupBackupPlanRuleDetails.Builder> ... var1);
    }
}

