/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Response;
import software.amazon.awssdk.services.securityhub.model.ProductV2;

public class DescribeProductsV2Publisher
implements SdkPublisher<DescribeProductsV2Response> {
    private final SecurityHubAsyncClient client;
    private final DescribeProductsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeProductsV2Publisher(SecurityHubAsyncClient client, DescribeProductsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeProductsV2Publisher(SecurityHubAsyncClient client, DescribeProductsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeProductsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeProductsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProductV2> productsV2() {
        Function<DescribeProductsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.productsV2() != null) {
                return response.productsV2().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeProductsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeProductsV2ResponseFetcher
    implements AsyncPageFetcher<DescribeProductsV2Response> {
        private DescribeProductsV2ResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProductsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeProductsV2Response> nextPage(DescribeProductsV2Response previousPage) {
            if (previousPage == null) {
                return DescribeProductsV2Publisher.this.client.describeProductsV2(DescribeProductsV2Publisher.this.firstRequest);
            }
            return DescribeProductsV2Publisher.this.client.describeProductsV2((DescribeProductsV2Request)((Object)DescribeProductsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

