/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringConfigurationOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(StringConfigurationOptions.getter(StringConfigurationOptions::defaultValue)).setter(StringConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> RE2_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Re2Expression").getter(StringConfigurationOptions.getter(StringConfigurationOptions::re2Expression)).setter(StringConfigurationOptions.setter(Builder::re2Expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Re2Expression").build()}).build();
    private static final SdkField<String> EXPRESSION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpressionDescription").getter(StringConfigurationOptions.getter(StringConfigurationOptions::expressionDescription)).setter(StringConfigurationOptions.setter(Builder::expressionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, RE2_EXPRESSION_FIELD, EXPRESSION_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StringConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String re2Expression;
    private final String expressionDescription;

    private StringConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.re2Expression = builder.re2Expression;
        this.expressionDescription = builder.expressionDescription;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String re2Expression() {
        return this.re2Expression;
    }

    public final String expressionDescription() {
        return this.expressionDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.re2Expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringConfigurationOptions)) {
            return false;
        }
        StringConfigurationOptions other = (StringConfigurationOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.re2Expression(), other.re2Expression()) && Objects.equals(this.expressionDescription(), other.expressionDescription());
    }

    public final String toString() {
        return ToString.builder((String)"StringConfigurationOptions").add("DefaultValue", (Object)this.defaultValue()).add("Re2Expression", (Object)this.re2Expression()).add("ExpressionDescription", (Object)this.expressionDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "Re2Expression": {
                return Optional.ofNullable(clazz.cast(this.re2Expression()));
            }
            case "ExpressionDescription": {
                return Optional.ofNullable(clazz.cast(this.expressionDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("Re2Expression", RE2_EXPRESSION_FIELD);
        map.put("ExpressionDescription", EXPRESSION_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StringConfigurationOptions, T> g) {
        return obj -> g.apply((StringConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String re2Expression;
        private String expressionDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(StringConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.re2Expression(model.re2Expression);
            this.expressionDescription(model.expressionDescription);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getRe2Expression() {
            return this.re2Expression;
        }

        public final void setRe2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
        }

        @Override
        public final Builder re2Expression(String re2Expression) {
            this.re2Expression = re2Expression;
            return this;
        }

        public final String getExpressionDescription() {
            return this.expressionDescription;
        }

        public final void setExpressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
        }

        @Override
        public final Builder expressionDescription(String expressionDescription) {
            this.expressionDescription = expressionDescription;
            return this;
        }

        public StringConfigurationOptions build() {
            return new StringConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringConfigurationOptions> {
        public Builder defaultValue(String var1);

        public Builder re2Expression(String var1);

        public Builder expressionDescription(String var1);
    }
}

