/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.CidrBlockAssociation;
import software.amazon.awssdk.services.securityhub.model.CidrBlockAssociationListCopier;
import software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociation;
import software.amazon.awssdk.services.securityhub.model.Ipv6CidrBlockAssociationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEc2VpcDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEc2VpcDetails> {
    private static final SdkField<List<CidrBlockAssociation>> CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlockAssociationSet").getter(AwsEc2VpcDetails.getter(AwsEc2VpcDetails::cidrBlockAssociationSet)).setter(AwsEc2VpcDetails.setter(Builder::cidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Ipv6CidrBlockAssociation>> IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6CidrBlockAssociationSet").getter(AwsEc2VpcDetails.getter(AwsEc2VpcDetails::ipv6CidrBlockAssociationSet)).setter(AwsEc2VpcDetails.setter(Builder::ipv6CidrBlockAssociationSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6CidrBlockAssociationSet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ipv6CidrBlockAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DHCP_OPTIONS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DhcpOptionsId").getter(AwsEc2VpcDetails.getter(AwsEc2VpcDetails::dhcpOptionsId)).setter(AwsEc2VpcDetails.setter(Builder::dhcpOptionsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpOptionsId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AwsEc2VpcDetails.getter(AwsEc2VpcDetails::state)).setter(AwsEc2VpcDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_BLOCK_ASSOCIATION_SET_FIELD, IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD, DHCP_OPTIONS_ID_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEc2VpcDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CidrBlockAssociation> cidrBlockAssociationSet;
    private final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private final String dhcpOptionsId;
    private final String state;

    private AwsEc2VpcDetails(BuilderImpl builder) {
        this.cidrBlockAssociationSet = builder.cidrBlockAssociationSet;
        this.ipv6CidrBlockAssociationSet = builder.ipv6CidrBlockAssociationSet;
        this.dhcpOptionsId = builder.dhcpOptionsId;
        this.state = builder.state;
    }

    public final boolean hasCidrBlockAssociationSet() {
        return this.cidrBlockAssociationSet != null && !(this.cidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<CidrBlockAssociation> cidrBlockAssociationSet() {
        return this.cidrBlockAssociationSet;
    }

    public final boolean hasIpv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet != null && !(this.ipv6CidrBlockAssociationSet instanceof SdkAutoConstructList);
    }

    public final List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet() {
        return this.ipv6CidrBlockAssociationSet;
    }

    public final String dhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public final String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlockAssociationSet() ? this.cidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dhcpOptionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VpcDetails)) {
            return false;
        }
        AwsEc2VpcDetails other = (AwsEc2VpcDetails)obj;
        return this.hasCidrBlockAssociationSet() == other.hasCidrBlockAssociationSet() && Objects.equals(this.cidrBlockAssociationSet(), other.cidrBlockAssociationSet()) && this.hasIpv6CidrBlockAssociationSet() == other.hasIpv6CidrBlockAssociationSet() && Objects.equals(this.ipv6CidrBlockAssociationSet(), other.ipv6CidrBlockAssociationSet()) && Objects.equals(this.dhcpOptionsId(), other.dhcpOptionsId()) && Objects.equals(this.state(), other.state());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEc2VpcDetails").add("CidrBlockAssociationSet", this.hasCidrBlockAssociationSet() ? this.cidrBlockAssociationSet() : null).add("Ipv6CidrBlockAssociationSet", this.hasIpv6CidrBlockAssociationSet() ? this.ipv6CidrBlockAssociationSet() : null).add("DhcpOptionsId", (Object)this.dhcpOptionsId()).add("State", (Object)this.state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.cidrBlockAssociationSet()));
            }
            case "Ipv6CidrBlockAssociationSet": {
                return Optional.ofNullable(clazz.cast(this.ipv6CidrBlockAssociationSet()));
            }
            case "DhcpOptionsId": {
                return Optional.ofNullable(clazz.cast(this.dhcpOptionsId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CidrBlockAssociationSet", CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        map.put("Ipv6CidrBlockAssociationSet", IPV6_CIDR_BLOCK_ASSOCIATION_SET_FIELD);
        map.put("DhcpOptionsId", DHCP_OPTIONS_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VpcDetails, T> g) {
        return obj -> g.apply((AwsEc2VpcDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CidrBlockAssociation> cidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private List<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet = DefaultSdkAutoConstructList.getInstance();
        private String dhcpOptionsId;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VpcDetails model) {
            this.cidrBlockAssociationSet(model.cidrBlockAssociationSet);
            this.ipv6CidrBlockAssociationSet(model.ipv6CidrBlockAssociationSet);
            this.dhcpOptionsId(model.dhcpOptionsId);
            this.state(model.state);
        }

        public final List<CidrBlockAssociation.Builder> getCidrBlockAssociationSet() {
            List<CidrBlockAssociation.Builder> result = CidrBlockAssociationListCopier.copyToBuilder(this.cidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlockAssociationSet(Collection<CidrBlockAssociation.BuilderImpl> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = CidrBlockAssociationListCopier.copyFromBuilder(cidrBlockAssociationSet);
        }

        @Override
        public final Builder cidrBlockAssociationSet(Collection<CidrBlockAssociation> cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet = CidrBlockAssociationListCopier.copy(cidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(CidrBlockAssociation ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Arrays.asList(cidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlockAssociationSet(Consumer<CidrBlockAssociation.Builder> ... cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet(Stream.of(cidrBlockAssociationSet).map(c -> (CidrBlockAssociation)((CidrBlockAssociation.Builder)CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Ipv6CidrBlockAssociation.Builder> getIpv6CidrBlockAssociationSet() {
            List<Ipv6CidrBlockAssociation.Builder> result = Ipv6CidrBlockAssociationListCopier.copyToBuilder(this.ipv6CidrBlockAssociationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation.BuilderImpl> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copyFromBuilder(ipv6CidrBlockAssociationSet);
        }

        @Override
        public final Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet = Ipv6CidrBlockAssociationListCopier.copy(ipv6CidrBlockAssociationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Arrays.asList(ipv6CidrBlockAssociationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder> ... ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet(Stream.of(ipv6CidrBlockAssociationSet).map(c -> (Ipv6CidrBlockAssociation)((Ipv6CidrBlockAssociation.Builder)Ipv6CidrBlockAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDhcpOptionsId() {
            return this.dhcpOptionsId;
        }

        public final void setDhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
        }

        @Override
        public final Builder dhcpOptionsId(String dhcpOptionsId) {
            this.dhcpOptionsId = dhcpOptionsId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public AwsEc2VpcDetails build() {
            return new AwsEc2VpcDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEc2VpcDetails> {
        public Builder cidrBlockAssociationSet(Collection<CidrBlockAssociation> var1);

        public Builder cidrBlockAssociationSet(CidrBlockAssociation ... var1);

        public Builder cidrBlockAssociationSet(Consumer<CidrBlockAssociation.Builder> ... var1);

        public Builder ipv6CidrBlockAssociationSet(Collection<Ipv6CidrBlockAssociation> var1);

        public Builder ipv6CidrBlockAssociationSet(Ipv6CidrBlockAssociation ... var1);

        public Builder ipv6CidrBlockAssociationSet(Consumer<Ipv6CidrBlockAssociation.Builder> ... var1);

        public Builder dhcpOptionsId(String var1);

        public Builder state(String var1);
    }
}

