/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerEncryptionOptionsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLdapServerMetadataDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersDetails;
import software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerUsersListCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsAmazonMqBrokerDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsAmazonMqBrokerDetails> {
    private static final SdkField<String> AUTHENTICATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthenticationStrategy").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::authenticationStrategy)).setter(AwsAmazonMqBrokerDetails.setter(Builder::authenticationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationStrategy").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::autoMinorVersionUpgrade)).setter(AwsAmazonMqBrokerDetails.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> BROKER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerArn").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::brokerArn)).setter(AwsAmazonMqBrokerDetails.setter(Builder::brokerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrokerArn").build()}).build();
    private static final SdkField<String> BROKER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerName").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::brokerName)).setter(AwsAmazonMqBrokerDetails.setter(Builder::brokerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrokerName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeploymentMode").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::deploymentMode)).setter(AwsAmazonMqBrokerDetails.setter(Builder::deploymentMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentMode").build()}).build();
    private static final SdkField<AwsAmazonMqBrokerEncryptionOptionsDetails> ENCRYPTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionOptions").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::encryptionOptions)).setter(AwsAmazonMqBrokerDetails.setter(Builder::encryptionOptions)).constructor(AwsAmazonMqBrokerEncryptionOptionsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionOptions").build()}).build();
    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineType").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::engineType)).setter(AwsAmazonMqBrokerDetails.setter(Builder::engineType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::engineVersion)).setter(AwsAmazonMqBrokerDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> HOST_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostInstanceType").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::hostInstanceType)).setter(AwsAmazonMqBrokerDetails.setter(Builder::hostInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostInstanceType").build()}).build();
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerId").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::brokerId)).setter(AwsAmazonMqBrokerDetails.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BrokerId").build()}).build();
    private static final SdkField<AwsAmazonMqBrokerLdapServerMetadataDetails> LDAP_SERVER_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LdapServerMetadata").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::ldapServerMetadata)).setter(AwsAmazonMqBrokerDetails.setter(Builder::ldapServerMetadata)).constructor(AwsAmazonMqBrokerLdapServerMetadataDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LdapServerMetadata").build()}).build();
    private static final SdkField<AwsAmazonMqBrokerLogsDetails> LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Logs").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::logs)).setter(AwsAmazonMqBrokerDetails.setter(Builder::logs)).constructor(AwsAmazonMqBrokerLogsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logs").build()}).build();
    private static final SdkField<AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails> MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceWindowStartTime").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::maintenanceWindowStartTime)).setter(AwsAmazonMqBrokerDetails.setter(Builder::maintenanceWindowStartTime)).constructor(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindowStartTime").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::publiclyAccessible)).setter(AwsAmazonMqBrokerDetails.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::securityGroups)).setter(AwsAmazonMqBrokerDetails.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::storageType)).setter(AwsAmazonMqBrokerDetails.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::subnetIds)).setter(AwsAmazonMqBrokerDetails.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsAmazonMqBrokerUsersDetails>> USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Users").getter(AwsAmazonMqBrokerDetails.getter(AwsAmazonMqBrokerDetails::users)).setter(AwsAmazonMqBrokerDetails.setter(Builder::users)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Users").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsAmazonMqBrokerUsersDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_STRATEGY_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, BROKER_ARN_FIELD, BROKER_NAME_FIELD, DEPLOYMENT_MODE_FIELD, ENCRYPTION_OPTIONS_FIELD, ENGINE_TYPE_FIELD, ENGINE_VERSION_FIELD, HOST_INSTANCE_TYPE_FIELD, BROKER_ID_FIELD, LDAP_SERVER_METADATA_FIELD, LOGS_FIELD, MAINTENANCE_WINDOW_START_TIME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_TYPE_FIELD, SUBNET_IDS_FIELD, USERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsAmazonMqBrokerDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authenticationStrategy;
    private final Boolean autoMinorVersionUpgrade;
    private final String brokerArn;
    private final String brokerName;
    private final String deploymentMode;
    private final AwsAmazonMqBrokerEncryptionOptionsDetails encryptionOptions;
    private final String engineType;
    private final String engineVersion;
    private final String hostInstanceType;
    private final String brokerId;
    private final AwsAmazonMqBrokerLdapServerMetadataDetails ldapServerMetadata;
    private final AwsAmazonMqBrokerLogsDetails logs;
    private final AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails maintenanceWindowStartTime;
    private final Boolean publiclyAccessible;
    private final List<String> securityGroups;
    private final String storageType;
    private final List<String> subnetIds;
    private final List<AwsAmazonMqBrokerUsersDetails> users;

    private AwsAmazonMqBrokerDetails(BuilderImpl builder) {
        this.authenticationStrategy = builder.authenticationStrategy;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.brokerArn = builder.brokerArn;
        this.brokerName = builder.brokerName;
        this.deploymentMode = builder.deploymentMode;
        this.encryptionOptions = builder.encryptionOptions;
        this.engineType = builder.engineType;
        this.engineVersion = builder.engineVersion;
        this.hostInstanceType = builder.hostInstanceType;
        this.brokerId = builder.brokerId;
        this.ldapServerMetadata = builder.ldapServerMetadata;
        this.logs = builder.logs;
        this.maintenanceWindowStartTime = builder.maintenanceWindowStartTime;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroups = builder.securityGroups;
        this.storageType = builder.storageType;
        this.subnetIds = builder.subnetIds;
        this.users = builder.users;
    }

    public final String authenticationStrategy() {
        return this.authenticationStrategy;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String brokerArn() {
        return this.brokerArn;
    }

    public final String brokerName() {
        return this.brokerName;
    }

    public final String deploymentMode() {
        return this.deploymentMode;
    }

    public final AwsAmazonMqBrokerEncryptionOptionsDetails encryptionOptions() {
        return this.encryptionOptions;
    }

    public final String engineType() {
        return this.engineType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String hostInstanceType() {
        return this.hostInstanceType;
    }

    public final String brokerId() {
        return this.brokerId;
    }

    public final AwsAmazonMqBrokerLdapServerMetadataDetails ldapServerMetadata() {
        return this.ldapServerMetadata;
    }

    public final AwsAmazonMqBrokerLogsDetails logs() {
        return this.logs;
    }

    public final AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails maintenanceWindowStartTime() {
        return this.maintenanceWindowStartTime;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasUsers() {
        return this.users != null && !(this.users instanceof SdkAutoConstructList);
    }

    public final List<AwsAmazonMqBrokerUsersDetails> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ldapServerMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsers() ? this.users() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAmazonMqBrokerDetails)) {
            return false;
        }
        AwsAmazonMqBrokerDetails other = (AwsAmazonMqBrokerDetails)obj;
        return Objects.equals(this.authenticationStrategy(), other.authenticationStrategy()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.brokerArn(), other.brokerArn()) && Objects.equals(this.brokerName(), other.brokerName()) && Objects.equals(this.deploymentMode(), other.deploymentMode()) && Objects.equals(this.encryptionOptions(), other.encryptionOptions()) && Objects.equals(this.engineType(), other.engineType()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.hostInstanceType(), other.hostInstanceType()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.ldapServerMetadata(), other.ldapServerMetadata()) && Objects.equals(this.logs(), other.logs()) && Objects.equals(this.maintenanceWindowStartTime(), other.maintenanceWindowStartTime()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.storageType(), other.storageType()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasUsers() == other.hasUsers() && Objects.equals(this.users(), other.users());
    }

    public final String toString() {
        return ToString.builder((String)"AwsAmazonMqBrokerDetails").add("AuthenticationStrategy", (Object)this.authenticationStrategy()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("BrokerArn", (Object)this.brokerArn()).add("BrokerName", (Object)this.brokerName()).add("DeploymentMode", (Object)this.deploymentMode()).add("EncryptionOptions", (Object)this.encryptionOptions()).add("EngineType", (Object)this.engineType()).add("EngineVersion", (Object)this.engineVersion()).add("HostInstanceType", (Object)this.hostInstanceType()).add("BrokerId", (Object)this.brokerId()).add("LdapServerMetadata", (Object)this.ldapServerMetadata()).add("Logs", (Object)this.logs()).add("MaintenanceWindowStartTime", (Object)this.maintenanceWindowStartTime()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("StorageType", (Object)this.storageType()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Users", this.hasUsers() ? this.users() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthenticationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authenticationStrategy()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "BrokerArn": {
                return Optional.ofNullable(clazz.cast(this.brokerArn()));
            }
            case "BrokerName": {
                return Optional.ofNullable(clazz.cast(this.brokerName()));
            }
            case "DeploymentMode": {
                return Optional.ofNullable(clazz.cast(this.deploymentMode()));
            }
            case "EncryptionOptions": {
                return Optional.ofNullable(clazz.cast(this.encryptionOptions()));
            }
            case "EngineType": {
                return Optional.ofNullable(clazz.cast(this.engineType()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "HostInstanceType": {
                return Optional.ofNullable(clazz.cast(this.hostInstanceType()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "LdapServerMetadata": {
                return Optional.ofNullable(clazz.cast(this.ldapServerMetadata()));
            }
            case "Logs": {
                return Optional.ofNullable(clazz.cast(this.logs()));
            }
            case "MaintenanceWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindowStartTime()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "Users": {
                return Optional.ofNullable(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthenticationStrategy", AUTHENTICATION_STRATEGY_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("BrokerArn", BROKER_ARN_FIELD);
        map.put("BrokerName", BROKER_NAME_FIELD);
        map.put("DeploymentMode", DEPLOYMENT_MODE_FIELD);
        map.put("EncryptionOptions", ENCRYPTION_OPTIONS_FIELD);
        map.put("EngineType", ENGINE_TYPE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("HostInstanceType", HOST_INSTANCE_TYPE_FIELD);
        map.put("BrokerId", BROKER_ID_FIELD);
        map.put("LdapServerMetadata", LDAP_SERVER_METADATA_FIELD);
        map.put("Logs", LOGS_FIELD);
        map.put("MaintenanceWindowStartTime", MAINTENANCE_WINDOW_START_TIME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("Users", USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAmazonMqBrokerDetails, T> g) {
        return obj -> g.apply((AwsAmazonMqBrokerDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authenticationStrategy;
        private Boolean autoMinorVersionUpgrade;
        private String brokerArn;
        private String brokerName;
        private String deploymentMode;
        private AwsAmazonMqBrokerEncryptionOptionsDetails encryptionOptions;
        private String engineType;
        private String engineVersion;
        private String hostInstanceType;
        private String brokerId;
        private AwsAmazonMqBrokerLdapServerMetadataDetails ldapServerMetadata;
        private AwsAmazonMqBrokerLogsDetails logs;
        private AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails maintenanceWindowStartTime;
        private Boolean publiclyAccessible;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<AwsAmazonMqBrokerUsersDetails> users = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAmazonMqBrokerDetails model) {
            this.authenticationStrategy(model.authenticationStrategy);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.brokerArn(model.brokerArn);
            this.brokerName(model.brokerName);
            this.deploymentMode(model.deploymentMode);
            this.encryptionOptions(model.encryptionOptions);
            this.engineType(model.engineType);
            this.engineVersion(model.engineVersion);
            this.hostInstanceType(model.hostInstanceType);
            this.brokerId(model.brokerId);
            this.ldapServerMetadata(model.ldapServerMetadata);
            this.logs(model.logs);
            this.maintenanceWindowStartTime(model.maintenanceWindowStartTime);
            this.publiclyAccessible(model.publiclyAccessible);
            this.securityGroups(model.securityGroups);
            this.storageType(model.storageType);
            this.subnetIds(model.subnetIds);
            this.users(model.users);
        }

        public final String getAuthenticationStrategy() {
            return this.authenticationStrategy;
        }

        public final void setAuthenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
        }

        @Override
        public final Builder authenticationStrategy(String authenticationStrategy) {
            this.authenticationStrategy = authenticationStrategy;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getBrokerArn() {
            return this.brokerArn;
        }

        public final void setBrokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
        }

        @Override
        public final Builder brokerArn(String brokerArn) {
            this.brokerArn = brokerArn;
            return this;
        }

        public final String getBrokerName() {
            return this.brokerName;
        }

        public final void setBrokerName(String brokerName) {
            this.brokerName = brokerName;
        }

        @Override
        public final Builder brokerName(String brokerName) {
            this.brokerName = brokerName;
            return this;
        }

        public final String getDeploymentMode() {
            return this.deploymentMode;
        }

        public final void setDeploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
        }

        @Override
        public final Builder deploymentMode(String deploymentMode) {
            this.deploymentMode = deploymentMode;
            return this;
        }

        public final AwsAmazonMqBrokerEncryptionOptionsDetails.Builder getEncryptionOptions() {
            return this.encryptionOptions != null ? this.encryptionOptions.toBuilder() : null;
        }

        public final void setEncryptionOptions(AwsAmazonMqBrokerEncryptionOptionsDetails.BuilderImpl encryptionOptions) {
            this.encryptionOptions = encryptionOptions != null ? encryptionOptions.build() : null;
        }

        @Override
        public final Builder encryptionOptions(AwsAmazonMqBrokerEncryptionOptionsDetails encryptionOptions) {
            this.encryptionOptions = encryptionOptions;
            return this;
        }

        public final String getEngineType() {
            return this.engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getHostInstanceType() {
            return this.hostInstanceType;
        }

        public final void setHostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
        }

        @Override
        public final Builder hostInstanceType(String hostInstanceType) {
            this.hostInstanceType = hostInstanceType;
            return this;
        }

        public final String getBrokerId() {
            return this.brokerId;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final AwsAmazonMqBrokerLdapServerMetadataDetails.Builder getLdapServerMetadata() {
            return this.ldapServerMetadata != null ? this.ldapServerMetadata.toBuilder() : null;
        }

        public final void setLdapServerMetadata(AwsAmazonMqBrokerLdapServerMetadataDetails.BuilderImpl ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata != null ? ldapServerMetadata.build() : null;
        }

        @Override
        public final Builder ldapServerMetadata(AwsAmazonMqBrokerLdapServerMetadataDetails ldapServerMetadata) {
            this.ldapServerMetadata = ldapServerMetadata;
            return this;
        }

        public final AwsAmazonMqBrokerLogsDetails.Builder getLogs() {
            return this.logs != null ? this.logs.toBuilder() : null;
        }

        public final void setLogs(AwsAmazonMqBrokerLogsDetails.BuilderImpl logs) {
            this.logs = logs != null ? logs.build() : null;
        }

        @Override
        public final Builder logs(AwsAmazonMqBrokerLogsDetails logs) {
            this.logs = logs;
            return this;
        }

        public final AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.Builder getMaintenanceWindowStartTime() {
            return this.maintenanceWindowStartTime != null ? this.maintenanceWindowStartTime.toBuilder() : null;
        }

        public final void setMaintenanceWindowStartTime(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.BuilderImpl maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime != null ? maintenanceWindowStartTime.build() : null;
        }

        @Override
        public final Builder maintenanceWindowStartTime(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails maintenanceWindowStartTime) {
            this.maintenanceWindowStartTime = maintenanceWindowStartTime;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final List<AwsAmazonMqBrokerUsersDetails.Builder> getUsers() {
            List<AwsAmazonMqBrokerUsersDetails.Builder> result = AwsAmazonMqBrokerUsersListCopier.copyToBuilder(this.users);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsers(Collection<AwsAmazonMqBrokerUsersDetails.BuilderImpl> users) {
            this.users = AwsAmazonMqBrokerUsersListCopier.copyFromBuilder(users);
        }

        @Override
        public final Builder users(Collection<AwsAmazonMqBrokerUsersDetails> users) {
            this.users = AwsAmazonMqBrokerUsersListCopier.copy(users);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(AwsAmazonMqBrokerUsersDetails ... users) {
            this.users(Arrays.asList(users));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder users(Consumer<AwsAmazonMqBrokerUsersDetails.Builder> ... users) {
            this.users(Stream.of(users).map(c -> (AwsAmazonMqBrokerUsersDetails)((AwsAmazonMqBrokerUsersDetails.Builder)AwsAmazonMqBrokerUsersDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsAmazonMqBrokerDetails build() {
            return new AwsAmazonMqBrokerDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsAmazonMqBrokerDetails> {
        public Builder authenticationStrategy(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder brokerArn(String var1);

        public Builder brokerName(String var1);

        public Builder deploymentMode(String var1);

        public Builder encryptionOptions(AwsAmazonMqBrokerEncryptionOptionsDetails var1);

        default public Builder encryptionOptions(Consumer<AwsAmazonMqBrokerEncryptionOptionsDetails.Builder> encryptionOptions) {
            return this.encryptionOptions((AwsAmazonMqBrokerEncryptionOptionsDetails)((AwsAmazonMqBrokerEncryptionOptionsDetails.Builder)AwsAmazonMqBrokerEncryptionOptionsDetails.builder().applyMutation(encryptionOptions)).build());
        }

        public Builder engineType(String var1);

        public Builder engineVersion(String var1);

        public Builder hostInstanceType(String var1);

        public Builder brokerId(String var1);

        public Builder ldapServerMetadata(AwsAmazonMqBrokerLdapServerMetadataDetails var1);

        default public Builder ldapServerMetadata(Consumer<AwsAmazonMqBrokerLdapServerMetadataDetails.Builder> ldapServerMetadata) {
            return this.ldapServerMetadata((AwsAmazonMqBrokerLdapServerMetadataDetails)((AwsAmazonMqBrokerLdapServerMetadataDetails.Builder)AwsAmazonMqBrokerLdapServerMetadataDetails.builder().applyMutation(ldapServerMetadata)).build());
        }

        public Builder logs(AwsAmazonMqBrokerLogsDetails var1);

        default public Builder logs(Consumer<AwsAmazonMqBrokerLogsDetails.Builder> logs) {
            return this.logs((AwsAmazonMqBrokerLogsDetails)((AwsAmazonMqBrokerLogsDetails.Builder)AwsAmazonMqBrokerLogsDetails.builder().applyMutation(logs)).build());
        }

        public Builder maintenanceWindowStartTime(AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails var1);

        default public Builder maintenanceWindowStartTime(Consumer<AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.Builder> maintenanceWindowStartTime) {
            return this.maintenanceWindowStartTime((AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails)((AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.Builder)AwsAmazonMqBrokerMaintenanceWindowStartTimeDetails.builder().applyMutation(maintenanceWindowStartTime)).build());
        }

        public Builder publiclyAccessible(Boolean var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder storageType(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder users(Collection<AwsAmazonMqBrokerUsersDetails> var1);

        public Builder users(AwsAmazonMqBrokerUsersDetails ... var1);

        public Builder users(Consumer<AwsAmazonMqBrokerUsersDetails.Builder> ... var1);
    }
}

