/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Target> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(Target.getter(Target::accountId)).setter(Target.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationalUnitId").getter(Target.getter(Target::organizationalUnitId)).setter(Target.setter(Builder::organizationalUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitId").build()}).build();
    private static final SdkField<String> ROOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RootId").getter(Target.getter(Target::rootId)).setter(Target.setter(Builder::rootId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ORGANIZATIONAL_UNIT_ID_FIELD, ROOT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Target.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String organizationalUnitId;
    private final String rootId;
    private final Type type;

    private Target(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.organizationalUnitId = builder.organizationalUnitId;
        this.rootId = builder.rootId;
        this.type = builder.type;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String organizationalUnitId() {
        return this.organizationalUnitId;
    }

    public final String rootId() {
        return this.rootId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.organizationalUnitId(), other.organizationalUnitId()) && Objects.equals(this.rootId(), other.rootId());
    }

    public final String toString() {
        return ToString.builder((String)"Target").add("AccountId", (Object)this.accountId()).add("OrganizationalUnitId", (Object)this.organizationalUnitId()).add("RootId", (Object)this.rootId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "OrganizationalUnitId": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitId()));
            }
            case "RootId": {
                return Optional.ofNullable(clazz.cast(this.rootId()));
            }
        }
        return Optional.empty();
    }

    public static Target fromAccountId(String accountId) {
        return (Target)Target.builder().accountId(accountId).build();
    }

    public static Target fromOrganizationalUnitId(String organizationalUnitId) {
        return (Target)Target.builder().organizationalUnitId(organizationalUnitId).build();
    }

    public static Target fromRootId(String rootId) {
        return (Target)Target.builder().rootId(rootId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("OrganizationalUnitId", ORGANIZATIONAL_UNIT_ID_FIELD);
        map.put("RootId", ROOT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Target, T> g) {
        return obj -> g.apply((Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ACCOUNT_ID,
        ORGANIZATIONAL_UNIT_ID,
        ROOT_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String organizationalUnitId;
        private String rootId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.accountId(model.accountId);
            this.organizationalUnitId(model.organizationalUnitId);
            this.rootId(model.rootId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            String oldValue = this.accountId;
            this.accountId = accountId;
            this.handleUnionValueChange(Type.ACCOUNT_ID, oldValue, this.accountId);
        }

        @Override
        public final Builder accountId(String accountId) {
            String oldValue = this.accountId;
            this.accountId = accountId;
            this.handleUnionValueChange(Type.ACCOUNT_ID, oldValue, this.accountId);
            return this;
        }

        public final String getOrganizationalUnitId() {
            return this.organizationalUnitId;
        }

        public final void setOrganizationalUnitId(String organizationalUnitId) {
            String oldValue = this.organizationalUnitId;
            this.organizationalUnitId = organizationalUnitId;
            this.handleUnionValueChange(Type.ORGANIZATIONAL_UNIT_ID, oldValue, this.organizationalUnitId);
        }

        @Override
        public final Builder organizationalUnitId(String organizationalUnitId) {
            String oldValue = this.organizationalUnitId;
            this.organizationalUnitId = organizationalUnitId;
            this.handleUnionValueChange(Type.ORGANIZATIONAL_UNIT_ID, oldValue, this.organizationalUnitId);
            return this;
        }

        public final String getRootId() {
            return this.rootId;
        }

        public final void setRootId(String rootId) {
            String oldValue = this.rootId;
            this.rootId = rootId;
            this.handleUnionValueChange(Type.ROOT_ID, oldValue, this.rootId);
        }

        @Override
        public final Builder rootId(String rootId) {
            String oldValue = this.rootId;
            this.rootId = rootId;
            this.handleUnionValueChange(Type.ROOT_ID, oldValue, this.rootId);
            return this;
        }

        public Target build() {
            return new Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Target> {
        public Builder accountId(String var1);

        public Builder organizationalUnitId(String var1);

        public Builder rootId(String var1);
    }
}

