/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleGroupSourceListDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleGroupSourceListDetails> {
    private static final SdkField<String> GENERATED_RULES_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GeneratedRulesType").getter(RuleGroupSourceListDetails.getter(RuleGroupSourceListDetails::generatedRulesType)).setter(RuleGroupSourceListDetails.setter(Builder::generatedRulesType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeneratedRulesType").build()}).build();
    private static final SdkField<List<String>> TARGET_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetTypes").getter(RuleGroupSourceListDetails.getter(RuleGroupSourceListDetails::targetTypes)).setter(RuleGroupSourceListDetails.setter(Builder::targetTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(RuleGroupSourceListDetails.getter(RuleGroupSourceListDetails::targets)).setter(RuleGroupSourceListDetails.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATED_RULES_TYPE_FIELD, TARGET_TYPES_FIELD, TARGETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleGroupSourceListDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String generatedRulesType;
    private final List<String> targetTypes;
    private final List<String> targets;

    private RuleGroupSourceListDetails(BuilderImpl builder) {
        this.generatedRulesType = builder.generatedRulesType;
        this.targetTypes = builder.targetTypes;
        this.targets = builder.targets;
    }

    public final String generatedRulesType() {
        return this.generatedRulesType;
    }

    public final boolean hasTargetTypes() {
        return this.targetTypes != null && !(this.targetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> targetTypes() {
        return this.targetTypes;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedRulesType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetTypes() ? this.targetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleGroupSourceListDetails)) {
            return false;
        }
        RuleGroupSourceListDetails other = (RuleGroupSourceListDetails)obj;
        return Objects.equals(this.generatedRulesType(), other.generatedRulesType()) && this.hasTargetTypes() == other.hasTargetTypes() && Objects.equals(this.targetTypes(), other.targetTypes()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets());
    }

    public final String toString() {
        return ToString.builder((String)"RuleGroupSourceListDetails").add("GeneratedRulesType", (Object)this.generatedRulesType()).add("TargetTypes", this.hasTargetTypes() ? this.targetTypes() : null).add("Targets", this.hasTargets() ? this.targets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GeneratedRulesType": {
                return Optional.ofNullable(clazz.cast(this.generatedRulesType()));
            }
            case "TargetTypes": {
                return Optional.ofNullable(clazz.cast(this.targetTypes()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("GeneratedRulesType", GENERATED_RULES_TYPE_FIELD);
        map.put("TargetTypes", TARGET_TYPES_FIELD);
        map.put("Targets", TARGETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleGroupSourceListDetails, T> g) {
        return obj -> g.apply((RuleGroupSourceListDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String generatedRulesType;
        private List<String> targetTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RuleGroupSourceListDetails model) {
            this.generatedRulesType(model.generatedRulesType);
            this.targetTypes(model.targetTypes);
            this.targets(model.targets);
        }

        public final String getGeneratedRulesType() {
            return this.generatedRulesType;
        }

        public final void setGeneratedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
        }

        @Override
        public final Builder generatedRulesType(String generatedRulesType) {
            this.generatedRulesType = generatedRulesType;
            return this;
        }

        public final Collection<String> getTargetTypes() {
            if (this.targetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetTypes;
        }

        public final void setTargetTypes(Collection<String> targetTypes) {
            this.targetTypes = NonEmptyStringListCopier.copy(targetTypes);
        }

        @Override
        public final Builder targetTypes(Collection<String> targetTypes) {
            this.targetTypes = NonEmptyStringListCopier.copy(targetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTypes(String ... targetTypes) {
            this.targetTypes(Arrays.asList(targetTypes));
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = NonEmptyStringListCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = NonEmptyStringListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public RuleGroupSourceListDetails build() {
            return new RuleGroupSourceListDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleGroupSourceListDetails> {
        public Builder generatedRulesType(String var1);

        public Builder targetTypes(Collection<String> var1);

        public Builder targetTypes(String ... var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);
    }
}

