/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnumConfigurationOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnumConfigurationOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultValue").getter(EnumConfigurationOptions.getter(EnumConfigurationOptions::defaultValue)).setter(EnumConfigurationOptions.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AllowedValues").getter(EnumConfigurationOptions.getter(EnumConfigurationOptions::allowedValues)).setter(EnumConfigurationOptions.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, ALLOWED_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnumConfigurationOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final List<String> allowedValues;

    private EnumConfigurationOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnumConfigurationOptions)) {
            return false;
        }
        EnumConfigurationOptions other = (EnumConfigurationOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues());
    }

    public final String toString() {
        return ToString.builder((String)"EnumConfigurationOptions").add("DefaultValue", (Object)this.defaultValue()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DefaultValue", DEFAULT_VALUE_FIELD);
        map.put("AllowedValues", ALLOWED_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnumConfigurationOptions, T> g) {
        return obj -> g.apply((EnumConfigurationOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnumConfigurationOptions model) {
            this.defaultValue(model.defaultValue);
            this.allowedValues(model.allowedValues);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = StringListCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = StringListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public EnumConfigurationOptions build() {
            return new EnumConfigurationOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnumConfigurationOptions> {
        public Builder defaultValue(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);
    }
}

