/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeName").getter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.getter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute::attributeName)).setter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.setter(Builder::attributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeValues").getter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.getter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute::attributeValues)).setter(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD, ATTRIBUTE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attributeName;
    private final List<String> attributeValues;

    private AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.attributeValues = builder.attributeValues;
    }

    public final String attributeName() {
        return this.attributeName;
    }

    public final boolean hasAttributeValues() {
        return this.attributeValues != null && !(this.attributeValues instanceof SdkAutoConstructList);
    }

    public final List<String> attributeValues() {
        return this.attributeValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValues() ? this.attributeValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute)) {
            return false;
        }
        AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute other = (AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute)obj;
        return Objects.equals(this.attributeName(), other.attributeName()) && this.hasAttributeValues() == other.hasAttributeValues() && Objects.equals(this.attributeValues(), other.attributeValues());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute").add("AttributeName", (Object)this.attributeName()).add("AttributeValues", this.hasAttributeValues() ? this.attributeValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
            case "AttributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttributeName", ATTRIBUTE_NAME_FIELD);
        map.put("AttributeValues", ATTRIBUTE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute, T> g) {
        return obj -> g.apply((AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeName;
        private List<String> attributeValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute model) {
            this.attributeName(model.attributeName);
            this.attributeValues(model.attributeValues);
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Collection<String> getAttributeValues() {
            if (this.attributeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeValues;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = NonEmptyStringListCopier.copy(attributeValues);
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = NonEmptyStringListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute build() {
            return new AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbClusterSnapshotDbClusterSnapshotAttribute> {
        public Builder attributeName(String var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);
    }
}

