/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterClusterSettingsDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterClusterSettingsListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterConfigurationDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEcsClusterDefaultCapacityProviderStrategyListCopier;
import software.amazon.awssdk.services.securityhub.model.NonEmptyStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEcsClusterDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEcsClusterDetails> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::clusterArn)).setter(AwsEcsClusterDetails.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<Integer> ACTIVE_SERVICES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ActiveServicesCount").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::activeServicesCount)).setter(AwsEcsClusterDetails.setter(Builder::activeServicesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveServicesCount").build()}).build();
    private static final SdkField<List<String>> CAPACITY_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityProviders").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::capacityProviders)).setter(AwsEcsClusterDetails.setter(Builder::capacityProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsEcsClusterClusterSettingsDetails>> CLUSTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSettings").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::clusterSettings)).setter(AwsEcsClusterDetails.setter(Builder::clusterSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsClusterClusterSettingsDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AwsEcsClusterConfigurationDetails> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::configuration)).setter(AwsEcsClusterDetails.setter(Builder::configuration)).constructor(AwsEcsClusterConfigurationDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final SdkField<List<AwsEcsClusterDefaultCapacityProviderStrategyDetails>> DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DefaultCapacityProviderStrategy").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::defaultCapacityProviderStrategy)).setter(AwsEcsClusterDetails.setter(Builder::defaultCapacityProviderStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCapacityProviderStrategy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEcsClusterDefaultCapacityProviderStrategyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::clusterName)).setter(AwsEcsClusterDetails.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<Integer> REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RegisteredContainerInstancesCount").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::registeredContainerInstancesCount)).setter(AwsEcsClusterDetails.setter(Builder::registeredContainerInstancesCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredContainerInstancesCount").build()}).build();
    private static final SdkField<Integer> RUNNING_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RunningTasksCount").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::runningTasksCount)).setter(AwsEcsClusterDetails.setter(Builder::runningTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunningTasksCount").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsEcsClusterDetails.getter(AwsEcsClusterDetails::status)).setter(AwsEcsClusterDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, ACTIVE_SERVICES_COUNT_FIELD, CAPACITY_PROVIDERS_FIELD, CLUSTER_SETTINGS_FIELD, CONFIGURATION_FIELD, DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD, CLUSTER_NAME_FIELD, REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD, RUNNING_TASKS_COUNT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsEcsClusterDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final Integer activeServicesCount;
    private final List<String> capacityProviders;
    private final List<AwsEcsClusterClusterSettingsDetails> clusterSettings;
    private final AwsEcsClusterConfigurationDetails configuration;
    private final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy;
    private final String clusterName;
    private final Integer registeredContainerInstancesCount;
    private final Integer runningTasksCount;
    private final String status;

    private AwsEcsClusterDetails(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.activeServicesCount = builder.activeServicesCount;
        this.capacityProviders = builder.capacityProviders;
        this.clusterSettings = builder.clusterSettings;
        this.configuration = builder.configuration;
        this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
        this.clusterName = builder.clusterName;
        this.registeredContainerInstancesCount = builder.registeredContainerInstancesCount;
        this.runningTasksCount = builder.runningTasksCount;
        this.status = builder.status;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final Integer activeServicesCount() {
        return this.activeServicesCount;
    }

    public final boolean hasCapacityProviders() {
        return this.capacityProviders != null && !(this.capacityProviders instanceof SdkAutoConstructList);
    }

    public final List<String> capacityProviders() {
        return this.capacityProviders;
    }

    public final boolean hasClusterSettings() {
        return this.clusterSettings != null && !(this.clusterSettings instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsClusterClusterSettingsDetails> clusterSettings() {
        return this.clusterSettings;
    }

    public final AwsEcsClusterConfigurationDetails configuration() {
        return this.configuration;
    }

    public final boolean hasDefaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy != null && !(this.defaultCapacityProviderStrategy instanceof SdkAutoConstructList);
    }

    public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy() {
        return this.defaultCapacityProviderStrategy;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Integer registeredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public final Integer runningTasksCount() {
        return this.runningTasksCount;
    }

    public final String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeServicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityProviders() ? this.capacityProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSettings() ? this.clusterSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredContainerInstancesCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runningTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterDetails)) {
            return false;
        }
        AwsEcsClusterDetails other = (AwsEcsClusterDetails)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.activeServicesCount(), other.activeServicesCount()) && this.hasCapacityProviders() == other.hasCapacityProviders() && Objects.equals(this.capacityProviders(), other.capacityProviders()) && this.hasClusterSettings() == other.hasClusterSettings() && Objects.equals(this.clusterSettings(), other.clusterSettings()) && Objects.equals(this.configuration(), other.configuration()) && this.hasDefaultCapacityProviderStrategy() == other.hasDefaultCapacityProviderStrategy() && Objects.equals(this.defaultCapacityProviderStrategy(), other.defaultCapacityProviderStrategy()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.registeredContainerInstancesCount(), other.registeredContainerInstancesCount()) && Objects.equals(this.runningTasksCount(), other.runningTasksCount()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEcsClusterDetails").add("ClusterArn", (Object)this.clusterArn()).add("ActiveServicesCount", (Object)this.activeServicesCount()).add("CapacityProviders", this.hasCapacityProviders() ? this.capacityProviders() : null).add("ClusterSettings", this.hasClusterSettings() ? this.clusterSettings() : null).add("Configuration", (Object)this.configuration()).add("DefaultCapacityProviderStrategy", this.hasDefaultCapacityProviderStrategy() ? this.defaultCapacityProviderStrategy() : null).add("ClusterName", (Object)this.clusterName()).add("RegisteredContainerInstancesCount", (Object)this.registeredContainerInstancesCount()).add("RunningTasksCount", (Object)this.runningTasksCount()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ActiveServicesCount": {
                return Optional.ofNullable(clazz.cast(this.activeServicesCount()));
            }
            case "CapacityProviders": {
                return Optional.ofNullable(clazz.cast(this.capacityProviders()));
            }
            case "ClusterSettings": {
                return Optional.ofNullable(clazz.cast(this.clusterSettings()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "DefaultCapacityProviderStrategy": {
                return Optional.ofNullable(clazz.cast(this.defaultCapacityProviderStrategy()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "RegisteredContainerInstancesCount": {
                return Optional.ofNullable(clazz.cast(this.registeredContainerInstancesCount()));
            }
            case "RunningTasksCount": {
                return Optional.ofNullable(clazz.cast(this.runningTasksCount()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ActiveServicesCount", ACTIVE_SERVICES_COUNT_FIELD);
        map.put("CapacityProviders", CAPACITY_PROVIDERS_FIELD);
        map.put("ClusterSettings", CLUSTER_SETTINGS_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("DefaultCapacityProviderStrategy", DEFAULT_CAPACITY_PROVIDER_STRATEGY_FIELD);
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("RegisteredContainerInstancesCount", REGISTERED_CONTAINER_INSTANCES_COUNT_FIELD);
        map.put("RunningTasksCount", RUNNING_TASKS_COUNT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsClusterDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private Integer activeServicesCount;
        private List<String> capacityProviders = DefaultSdkAutoConstructList.getInstance();
        private List<AwsEcsClusterClusterSettingsDetails> clusterSettings = DefaultSdkAutoConstructList.getInstance();
        private AwsEcsClusterConfigurationDetails configuration;
        private List<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy = DefaultSdkAutoConstructList.getInstance();
        private String clusterName;
        private Integer registeredContainerInstancesCount;
        private Integer runningTasksCount;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterDetails model) {
            this.clusterArn(model.clusterArn);
            this.activeServicesCount(model.activeServicesCount);
            this.capacityProviders(model.capacityProviders);
            this.clusterSettings(model.clusterSettings);
            this.configuration(model.configuration);
            this.defaultCapacityProviderStrategy(model.defaultCapacityProviderStrategy);
            this.clusterName(model.clusterName);
            this.registeredContainerInstancesCount(model.registeredContainerInstancesCount);
            this.runningTasksCount(model.runningTasksCount);
            this.status(model.status);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final Integer getActiveServicesCount() {
            return this.activeServicesCount;
        }

        public final void setActiveServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
        }

        @Override
        public final Builder activeServicesCount(Integer activeServicesCount) {
            this.activeServicesCount = activeServicesCount;
            return this;
        }

        public final Collection<String> getCapacityProviders() {
            if (this.capacityProviders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capacityProviders;
        }

        public final void setCapacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
        }

        @Override
        public final Builder capacityProviders(Collection<String> capacityProviders) {
            this.capacityProviders = NonEmptyStringListCopier.copy(capacityProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviders(String ... capacityProviders) {
            this.capacityProviders(Arrays.asList(capacityProviders));
            return this;
        }

        public final List<AwsEcsClusterClusterSettingsDetails.Builder> getClusterSettings() {
            List<AwsEcsClusterClusterSettingsDetails.Builder> result = AwsEcsClusterClusterSettingsListCopier.copyToBuilder(this.clusterSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSettings(Collection<AwsEcsClusterClusterSettingsDetails.BuilderImpl> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copyFromBuilder(clusterSettings);
        }

        @Override
        public final Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> clusterSettings) {
            this.clusterSettings = AwsEcsClusterClusterSettingsListCopier.copy(clusterSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSettings(AwsEcsClusterClusterSettingsDetails ... clusterSettings) {
            this.clusterSettings(Arrays.asList(clusterSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder> ... clusterSettings) {
            this.clusterSettings(Stream.of(clusterSettings).map(c -> (AwsEcsClusterClusterSettingsDetails)((AwsEcsClusterClusterSettingsDetails.Builder)AwsEcsClusterClusterSettingsDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AwsEcsClusterConfigurationDetails.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AwsEcsClusterConfigurationDetails.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AwsEcsClusterConfigurationDetails configuration) {
            this.configuration = configuration;
            return this;
        }

        public final List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> getDefaultCapacityProviderStrategy() {
            List<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> result = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copyToBuilder(this.defaultCapacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails.BuilderImpl> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copyFromBuilder(defaultCapacityProviderStrategy);
        }

        @Override
        public final Builder defaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = AwsEcsClusterDefaultCapacityProviderStrategyListCopier.copy(defaultCapacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(AwsEcsClusterDefaultCapacityProviderStrategyDetails ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Arrays.asList(defaultCapacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultCapacityProviderStrategy(Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> ... defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy(Stream.of(defaultCapacityProviderStrategy).map(c -> (AwsEcsClusterDefaultCapacityProviderStrategyDetails)((AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder)AwsEcsClusterDefaultCapacityProviderStrategyDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Integer getRegisteredContainerInstancesCount() {
            return this.registeredContainerInstancesCount;
        }

        public final void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
        }

        @Override
        public final Builder registeredContainerInstancesCount(Integer registeredContainerInstancesCount) {
            this.registeredContainerInstancesCount = registeredContainerInstancesCount;
            return this;
        }

        public final Integer getRunningTasksCount() {
            return this.runningTasksCount;
        }

        public final void setRunningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
        }

        @Override
        public final Builder runningTasksCount(Integer runningTasksCount) {
            this.runningTasksCount = runningTasksCount;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public AwsEcsClusterDetails build() {
            return new AwsEcsClusterDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEcsClusterDetails> {
        public Builder clusterArn(String var1);

        public Builder activeServicesCount(Integer var1);

        public Builder capacityProviders(Collection<String> var1);

        public Builder capacityProviders(String ... var1);

        public Builder clusterSettings(Collection<AwsEcsClusterClusterSettingsDetails> var1);

        public Builder clusterSettings(AwsEcsClusterClusterSettingsDetails ... var1);

        public Builder clusterSettings(Consumer<AwsEcsClusterClusterSettingsDetails.Builder> ... var1);

        public Builder configuration(AwsEcsClusterConfigurationDetails var1);

        default public Builder configuration(Consumer<AwsEcsClusterConfigurationDetails.Builder> configuration) {
            return this.configuration((AwsEcsClusterConfigurationDetails)((AwsEcsClusterConfigurationDetails.Builder)AwsEcsClusterConfigurationDetails.builder().applyMutation(configuration)).build());
        }

        public Builder defaultCapacityProviderStrategy(Collection<AwsEcsClusterDefaultCapacityProviderStrategyDetails> var1);

        public Builder defaultCapacityProviderStrategy(AwsEcsClusterDefaultCapacityProviderStrategyDetails ... var1);

        public Builder defaultCapacityProviderStrategy(Consumer<AwsEcsClusterDefaultCapacityProviderStrategyDetails.Builder> ... var1);

        public Builder clusterName(String var1);

        public Builder registeredContainerInstancesCount(Integer var1);

        public Builder runningTasksCount(Integer var1);

        public Builder status(String var1);
    }
}

