/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Adjustment;
import software.amazon.awssdk.services.securityhub.model.AdjustmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cvss
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cvss> {
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Cvss.getter(Cvss::version)).setter(Cvss.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<Double> BASE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BaseScore").getter(Cvss.getter(Cvss::baseScore)).setter(Cvss.setter(Builder::baseScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseScore").build()}).build();
    private static final SdkField<String> BASE_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BaseVector").getter(Cvss.getter(Cvss::baseVector)).setter(Cvss.setter(Builder::baseVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseVector").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Cvss.getter(Cvss::source)).setter(Cvss.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<Adjustment>> ADJUSTMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Adjustments").getter(Cvss.getter(Cvss::adjustments)).setter(Cvss.setter(Builder::adjustments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adjustments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Adjustment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD, BASE_SCORE_FIELD, BASE_VECTOR_FIELD, SOURCE_FIELD, ADJUSTMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String version;
    private final Double baseScore;
    private final String baseVector;
    private final String source;
    private final List<Adjustment> adjustments;

    private Cvss(BuilderImpl builder) {
        this.version = builder.version;
        this.baseScore = builder.baseScore;
        this.baseVector = builder.baseVector;
        this.source = builder.source;
        this.adjustments = builder.adjustments;
    }

    public final String version() {
        return this.version;
    }

    public final Double baseScore() {
        return this.baseScore;
    }

    public final String baseVector() {
        return this.baseVector;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasAdjustments() {
        return this.adjustments != null && !(this.adjustments instanceof SdkAutoConstructList);
    }

    public final List<Adjustment> adjustments() {
        return this.adjustments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdjustments() ? this.adjustments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cvss)) {
            return false;
        }
        Cvss other = (Cvss)obj;
        return Objects.equals(this.version(), other.version()) && Objects.equals(this.baseScore(), other.baseScore()) && Objects.equals(this.baseVector(), other.baseVector()) && Objects.equals(this.source(), other.source()) && this.hasAdjustments() == other.hasAdjustments() && Objects.equals(this.adjustments(), other.adjustments());
    }

    public final String toString() {
        return ToString.builder((String)"Cvss").add("Version", (Object)this.version()).add("BaseScore", (Object)this.baseScore()).add("BaseVector", (Object)this.baseVector()).add("Source", (Object)this.source()).add("Adjustments", this.hasAdjustments() ? this.adjustments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "BaseScore": {
                return Optional.ofNullable(clazz.cast(this.baseScore()));
            }
            case "BaseVector": {
                return Optional.ofNullable(clazz.cast(this.baseVector()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Adjustments": {
                return Optional.ofNullable(clazz.cast(this.adjustments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cvss, T> g) {
        return obj -> g.apply((Cvss)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String version;
        private Double baseScore;
        private String baseVector;
        private String source;
        private List<Adjustment> adjustments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cvss model) {
            this.version(model.version);
            this.baseScore(model.baseScore);
            this.baseVector(model.baseVector);
            this.source(model.source);
            this.adjustments(model.adjustments);
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Double getBaseScore() {
            return this.baseScore;
        }

        public final void setBaseScore(Double baseScore) {
            this.baseScore = baseScore;
        }

        @Override
        public final Builder baseScore(Double baseScore) {
            this.baseScore = baseScore;
            return this;
        }

        public final String getBaseVector() {
            return this.baseVector;
        }

        public final void setBaseVector(String baseVector) {
            this.baseVector = baseVector;
        }

        @Override
        public final Builder baseVector(String baseVector) {
            this.baseVector = baseVector;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final List<Adjustment.Builder> getAdjustments() {
            List<Adjustment.Builder> result = AdjustmentListCopier.copyToBuilder(this.adjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdjustments(Collection<Adjustment.BuilderImpl> adjustments) {
            this.adjustments = AdjustmentListCopier.copyFromBuilder(adjustments);
        }

        @Override
        public final Builder adjustments(Collection<Adjustment> adjustments) {
            this.adjustments = AdjustmentListCopier.copy(adjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(Adjustment ... adjustments) {
            this.adjustments(Arrays.asList(adjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(Consumer<Adjustment.Builder> ... adjustments) {
            this.adjustments(Stream.of(adjustments).map(c -> (Adjustment)((Adjustment.Builder)Adjustment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Cvss build() {
            return new Cvss(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cvss> {
        public Builder version(String var1);

        public Builder baseScore(Double var1);

        public Builder baseVector(String var1);

        public Builder source(String var1);

        public Builder adjustments(Collection<Adjustment> var1);

        public Builder adjustments(Adjustment ... var1);

        public Builder adjustments(Consumer<Adjustment.Builder> ... var1);
    }
}

