/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRole;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterAssociatedRolesCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMember;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterMembersCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembership;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbClusterOptionGroupMembershipsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembershipsCopier;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup;
import software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroupsCopier;
import software.amazon.awssdk.services.securityhub.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsRdsDbClusterDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsRdsDbClusterDetails> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::allocatedStorage)).setter(AwsRdsDbClusterDetails.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::availabilityZones)).setter(AwsRdsDbClusterDetails.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::backupRetentionPeriod)).setter(AwsRdsDbClusterDetails.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::databaseName)).setter(AwsRdsDbClusterDetails.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::status)).setter(AwsRdsDbClusterDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::endpoint)).setter(AwsRdsDbClusterDetails.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> READER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReaderEndpoint").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::readerEndpoint)).setter(AwsRdsDbClusterDetails.setter(Builder::readerEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderEndpoint").build()}).build();
    private static final SdkField<List<String>> CUSTOM_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomEndpoints").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::customEndpoints)).setter(AwsRdsDbClusterDetails.setter(Builder::customEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAz").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::multiAz)).setter(AwsRdsDbClusterDetails.setter(Builder::multiAz)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAz").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::engine)).setter(AwsRdsDbClusterDetails.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::engineVersion)).setter(AwsRdsDbClusterDetails.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::port)).setter(AwsRdsDbClusterDetails.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::masterUsername)).setter(AwsRdsDbClusterDetails.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::preferredBackupWindow)).setter(AwsRdsDbClusterDetails.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::preferredMaintenanceWindow)).setter(AwsRdsDbClusterDetails.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<List<String>> READ_REPLICA_IDENTIFIERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReadReplicaIdentifiers").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::readReplicaIdentifiers)).setter(AwsRdsDbClusterDetails.setter(Builder::readReplicaIdentifiers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaIdentifiers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AwsRdsDbInstanceVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::vpcSecurityGroups)).setter(AwsRdsDbClusterDetails.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbInstanceVpcSecurityGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::hostedZoneId)).setter(AwsRdsDbClusterDetails.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::storageEncrypted)).setter(AwsRdsDbClusterDetails.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::kmsKeyId)).setter(AwsRdsDbClusterDetails.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> DB_CLUSTER_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterResourceId").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbClusterResourceId)).setter(AwsRdsDbClusterDetails.setter(Builder::dbClusterResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterResourceId").build()}).build();
    private static final SdkField<List<AwsRdsDbClusterAssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssociatedRoles").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::associatedRoles)).setter(AwsRdsDbClusterDetails.setter(Builder::associatedRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbClusterAssociatedRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterCreateTime").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::clusterCreateTime)).setter(AwsRdsDbClusterDetails.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<List<String>> ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnabledCloudWatchLogsExports").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::enabledCloudWatchLogsExports)).setter(AwsRdsDbClusterDetails.setter(Builder::enabledCloudWatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudWatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::engineMode)).setter(AwsRdsDbClusterDetails.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::deletionProtection)).setter(AwsRdsDbClusterDetails.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Boolean> HTTP_ENDPOINT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HttpEndpointEnabled").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::httpEndpointEnabled)).setter(AwsRdsDbClusterDetails.setter(Builder::httpEndpointEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointEnabled").build()}).build();
    private static final SdkField<String> ACTIVITY_STREAM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActivityStreamStatus").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::activityStreamStatus)).setter(AwsRdsDbClusterDetails.setter(Builder::activityStreamStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityStreamStatus").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::copyTagsToSnapshot)).setter(AwsRdsDbClusterDetails.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Boolean> CROSS_ACCOUNT_CLONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CrossAccountClone").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::crossAccountClone)).setter(AwsRdsDbClusterDetails.setter(Builder::crossAccountClone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossAccountClone").build()}).build();
    private static final SdkField<List<AwsRdsDbDomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainMemberships").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::domainMemberships)).setter(AwsRdsDbClusterDetails.setter(Builder::domainMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbDomainMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterParameterGroup").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbClusterParameterGroup)).setter(AwsRdsDbClusterDetails.setter(Builder::dbClusterParameterGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterParameterGroup").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbSubnetGroup").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbSubnetGroup)).setter(AwsRdsDbClusterDetails.setter(Builder::dbSubnetGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroup").build()}).build();
    private static final SdkField<List<AwsRdsDbClusterOptionGroupMembership>> DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DbClusterOptionGroupMemberships").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbClusterOptionGroupMemberships)).setter(AwsRdsDbClusterDetails.setter(Builder::dbClusterOptionGroupMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterOptionGroupMemberships").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbClusterOptionGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DbClusterIdentifier").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbClusterIdentifier)).setter(AwsRdsDbClusterDetails.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterIdentifier").build()}).build();
    private static final SdkField<List<AwsRdsDbClusterMember>> DB_CLUSTER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DbClusterMembers").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::dbClusterMembers)).setter(AwsRdsDbClusterDetails.setter(Builder::dbClusterMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterMembers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsRdsDbClusterMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IamDatabaseAuthenticationEnabled").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::iamDatabaseAuthenticationEnabled)).setter(AwsRdsDbClusterDetails.setter(Builder::iamDatabaseAuthenticationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamDatabaseAuthenticationEnabled").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(AwsRdsDbClusterDetails.getter(AwsRdsDbClusterDetails::autoMinorVersionUpgrade)).setter(AwsRdsDbClusterDetails.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD, AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, DATABASE_NAME_FIELD, STATUS_FIELD, ENDPOINT_FIELD, READER_ENDPOINT_FIELD, CUSTOM_ENDPOINTS_FIELD, MULTI_AZ_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, READ_REPLICA_IDENTIFIERS_FIELD, VPC_SECURITY_GROUPS_FIELD, HOSTED_ZONE_ID_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, DB_CLUSTER_RESOURCE_ID_FIELD, ASSOCIATED_ROLES_FIELD, CLUSTER_CREATE_TIME_FIELD, ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, DELETION_PROTECTION_FIELD, HTTP_ENDPOINT_ENABLED_FIELD, ACTIVITY_STREAM_STATUS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, CROSS_ACCOUNT_CLONE_FIELD, DOMAIN_MEMBERSHIPS_FIELD, DB_CLUSTER_PARAMETER_GROUP_FIELD, DB_SUBNET_GROUP_FIELD, DB_CLUSTER_OPTION_GROUP_MEMBERSHIPS_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_MEMBERS_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer allocatedStorage;
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String databaseName;
    private final String status;
    private final String endpoint;
    private final String readerEndpoint;
    private final List<String> customEndpoints;
    private final Boolean multiAz;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String masterUsername;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final List<String> readReplicaIdentifiers;
    private final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups;
    private final String hostedZoneId;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterResourceId;
    private final List<AwsRdsDbClusterAssociatedRole> associatedRoles;
    private final String clusterCreateTime;
    private final List<String> enabledCloudWatchLogsExports;
    private final String engineMode;
    private final Boolean deletionProtection;
    private final Boolean httpEndpointEnabled;
    private final String activityStreamStatus;
    private final Boolean copyTagsToSnapshot;
    private final Boolean crossAccountClone;
    private final List<AwsRdsDbDomainMembership> domainMemberships;
    private final String dbClusterParameterGroup;
    private final String dbSubnetGroup;
    private final List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships;
    private final String dbClusterIdentifier;
    private final List<AwsRdsDbClusterMember> dbClusterMembers;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final Boolean autoMinorVersionUpgrade;

    private AwsRdsDbClusterDetails(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.databaseName = builder.databaseName;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.customEndpoints = builder.customEndpoints;
        this.multiAz = builder.multiAz;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.associatedRoles = builder.associatedRoles;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.enabledCloudWatchLogsExports = builder.enabledCloudWatchLogsExports;
        this.engineMode = builder.engineMode;
        this.deletionProtection = builder.deletionProtection;
        this.httpEndpointEnabled = builder.httpEndpointEnabled;
        this.activityStreamStatus = builder.activityStreamStatus;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.crossAccountClone = builder.crossAccountClone;
        this.domainMemberships = builder.domainMemberships;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String status() {
        return this.status;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String readerEndpoint() {
        return this.readerEndpoint;
    }

    public final boolean hasCustomEndpoints() {
        return this.customEndpoints != null && !(this.customEndpoints instanceof SdkAutoConstructList);
    }

    public final List<String> customEndpoints() {
        return this.customEndpoints;
    }

    public final Boolean multiAz() {
        return this.multiAz;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final boolean hasReadReplicaIdentifiers() {
        return this.readReplicaIdentifiers != null && !(this.readReplicaIdentifiers instanceof SdkAutoConstructList);
    }

    public final List<String> readReplicaIdentifiers() {
        return this.readReplicaIdentifiers;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public final boolean hasAssociatedRoles() {
        return this.associatedRoles != null && !(this.associatedRoles instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbClusterAssociatedRole> associatedRoles() {
        return this.associatedRoles;
    }

    public final String clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final boolean hasEnabledCloudWatchLogsExports() {
        return this.enabledCloudWatchLogsExports != null && !(this.enabledCloudWatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enabledCloudWatchLogsExports() {
        return this.enabledCloudWatchLogsExports;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Boolean httpEndpointEnabled() {
        return this.httpEndpointEnabled;
    }

    public final String activityStreamStatus() {
        return this.activityStreamStatus;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Boolean crossAccountClone() {
        return this.crossAccountClone;
    }

    public final boolean hasDomainMemberships() {
        return this.domainMemberships != null && !(this.domainMemberships instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbDomainMembership> domainMemberships() {
        return this.domainMemberships;
    }

    public final String dbClusterParameterGroup() {
        return this.dbClusterParameterGroup;
    }

    public final String dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public final boolean hasDbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships != null && !(this.dbClusterOptionGroupMemberships instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final boolean hasDbClusterMembers() {
        return this.dbClusterMembers != null && !(this.dbClusterMembers instanceof SdkAutoConstructList);
    }

    public final List<AwsRdsDbClusterMember> dbClusterMembers() {
        return this.dbClusterMembers;
    }

    public final Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.readerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomEndpoints() ? this.customEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAz());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedRoles() ? this.associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledCloudWatchLogsExports() ? this.enabledCloudWatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.activityStreamStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossAccountClone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainMemberships() ? this.domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbClusterMembers() ? this.dbClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterDetails)) {
            return false;
        }
        AwsRdsDbClusterDetails other = (AwsRdsDbClusterDetails)obj;
        return Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.readerEndpoint(), other.readerEndpoint()) && this.hasCustomEndpoints() == other.hasCustomEndpoints() && Objects.equals(this.customEndpoints(), other.customEndpoints()) && Objects.equals(this.multiAz(), other.multiAz()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && this.hasReadReplicaIdentifiers() == other.hasReadReplicaIdentifiers() && Objects.equals(this.readReplicaIdentifiers(), other.readReplicaIdentifiers()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.dbClusterResourceId(), other.dbClusterResourceId()) && this.hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(this.associatedRoles(), other.associatedRoles()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && this.hasEnabledCloudWatchLogsExports() == other.hasEnabledCloudWatchLogsExports() && Objects.equals(this.enabledCloudWatchLogsExports(), other.enabledCloudWatchLogsExports()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.httpEndpointEnabled(), other.httpEndpointEnabled()) && Objects.equals(this.activityStreamStatus(), other.activityStreamStatus()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.crossAccountClone(), other.crossAccountClone()) && this.hasDomainMemberships() == other.hasDomainMemberships() && Objects.equals(this.domainMemberships(), other.domainMemberships()) && Objects.equals(this.dbClusterParameterGroup(), other.dbClusterParameterGroup()) && Objects.equals(this.dbSubnetGroup(), other.dbSubnetGroup()) && this.hasDbClusterOptionGroupMemberships() == other.hasDbClusterOptionGroupMemberships() && Objects.equals(this.dbClusterOptionGroupMemberships(), other.dbClusterOptionGroupMemberships()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && this.hasDbClusterMembers() == other.hasDbClusterMembers() && Objects.equals(this.dbClusterMembers(), other.dbClusterMembers()) && Objects.equals(this.iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade());
    }

    public final String toString() {
        return ToString.builder((String)"AwsRdsDbClusterDetails").add("AllocatedStorage", (Object)this.allocatedStorage()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("DatabaseName", (Object)this.databaseName()).add("Status", (Object)this.status()).add("Endpoint", (Object)this.endpoint()).add("ReaderEndpoint", (Object)this.readerEndpoint()).add("CustomEndpoints", this.hasCustomEndpoints() ? this.customEndpoints() : null).add("MultiAz", (Object)this.multiAz()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReadReplicaIdentifiers", this.hasReadReplicaIdentifiers() ? this.readReplicaIdentifiers() : null).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("HostedZoneId", (Object)this.hostedZoneId()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("DbClusterResourceId", (Object)this.dbClusterResourceId()).add("AssociatedRoles", this.hasAssociatedRoles() ? this.associatedRoles() : null).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("EnabledCloudWatchLogsExports", this.hasEnabledCloudWatchLogsExports() ? this.enabledCloudWatchLogsExports() : null).add("EngineMode", (Object)this.engineMode()).add("DeletionProtection", (Object)this.deletionProtection()).add("HttpEndpointEnabled", (Object)this.httpEndpointEnabled()).add("ActivityStreamStatus", (Object)this.activityStreamStatus()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("CrossAccountClone", (Object)this.crossAccountClone()).add("DomainMemberships", this.hasDomainMemberships() ? this.domainMemberships() : null).add("DbClusterParameterGroup", (Object)this.dbClusterParameterGroup()).add("DbSubnetGroup", (Object)this.dbSubnetGroup()).add("DbClusterOptionGroupMemberships", this.hasDbClusterOptionGroupMemberships() ? this.dbClusterOptionGroupMemberships() : null).add("DbClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DbClusterMembers", this.hasDbClusterMembers() ? this.dbClusterMembers() : null).add("IamDatabaseAuthenticationEnabled", (Object)this.iamDatabaseAuthenticationEnabled()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ReaderEndpoint": {
                return Optional.ofNullable(clazz.cast(this.readerEndpoint()));
            }
            case "CustomEndpoints": {
                return Optional.ofNullable(clazz.cast(this.customEndpoints()));
            }
            case "MultiAz": {
                return Optional.ofNullable(clazz.cast(this.multiAz()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReadReplicaIdentifiers": {
                return Optional.ofNullable(clazz.cast(this.readReplicaIdentifiers()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "DbClusterResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterResourceId()));
            }
            case "AssociatedRoles": {
                return Optional.ofNullable(clazz.cast(this.associatedRoles()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "EnabledCloudWatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enabledCloudWatchLogsExports()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "HttpEndpointEnabled": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointEnabled()));
            }
            case "ActivityStreamStatus": {
                return Optional.ofNullable(clazz.cast(this.activityStreamStatus()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "CrossAccountClone": {
                return Optional.ofNullable(clazz.cast(this.crossAccountClone()));
            }
            case "DomainMemberships": {
                return Optional.ofNullable(clazz.cast(this.domainMemberships()));
            }
            case "DbClusterParameterGroup": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroup()));
            }
            case "DbSubnetGroup": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroup()));
            }
            case "DbClusterOptionGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.dbClusterOptionGroupMemberships()));
            }
            case "DbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DbClusterMembers": {
                return Optional.ofNullable(clazz.cast(this.dbClusterMembers()));
            }
            case "IamDatabaseAuthenticationEnabled": {
                return Optional.ofNullable(clazz.cast(this.iamDatabaseAuthenticationEnabled()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterDetails, T> g) {
        return obj -> g.apply((AwsRdsDbClusterDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionPeriod;
        private String databaseName;
        private String status;
        private String endpoint;
        private String readerEndpoint;
        private List<String> customEndpoints = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiAz;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String masterUsername;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private List<String> readReplicaIdentifiers = DefaultSdkAutoConstructList.getInstance();
        private List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private String hostedZoneId;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterResourceId;
        private List<AwsRdsDbClusterAssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();
        private String clusterCreateTime;
        private List<String> enabledCloudWatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private String engineMode;
        private Boolean deletionProtection;
        private Boolean httpEndpointEnabled;
        private String activityStreamStatus;
        private Boolean copyTagsToSnapshot;
        private Boolean crossAccountClone;
        private List<AwsRdsDbDomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterParameterGroup;
        private String dbSubnetGroup;
        private List<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private String dbClusterIdentifier;
        private List<AwsRdsDbClusterMember> dbClusterMembers = DefaultSdkAutoConstructList.getInstance();
        private Boolean iamDatabaseAuthenticationEnabled;
        private Boolean autoMinorVersionUpgrade;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterDetails model) {
            this.allocatedStorage(model.allocatedStorage);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.databaseName(model.databaseName);
            this.status(model.status);
            this.endpoint(model.endpoint);
            this.readerEndpoint(model.readerEndpoint);
            this.customEndpoints(model.customEndpoints);
            this.multiAz(model.multiAz);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.readReplicaIdentifiers(model.readReplicaIdentifiers);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.hostedZoneId(model.hostedZoneId);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.dbClusterResourceId(model.dbClusterResourceId);
            this.associatedRoles(model.associatedRoles);
            this.clusterCreateTime(model.clusterCreateTime);
            this.enabledCloudWatchLogsExports(model.enabledCloudWatchLogsExports);
            this.engineMode(model.engineMode);
            this.deletionProtection(model.deletionProtection);
            this.httpEndpointEnabled(model.httpEndpointEnabled);
            this.activityStreamStatus(model.activityStreamStatus);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.crossAccountClone(model.crossAccountClone);
            this.domainMemberships(model.domainMemberships);
            this.dbClusterParameterGroup(model.dbClusterParameterGroup);
            this.dbSubnetGroup(model.dbSubnetGroup);
            this.dbClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterMembers(model.dbClusterMembers);
            this.iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final Collection<String> getCustomEndpoints() {
            if (this.customEndpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customEndpoints;
        }

        public final void setCustomEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
        }

        @Override
        public final Builder customEndpoints(Collection<String> customEndpoints) {
            this.customEndpoints = StringListCopier.copy(customEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customEndpoints(String ... customEndpoints) {
            this.customEndpoints(Arrays.asList(customEndpoints));
            return this;
        }

        public final Boolean getMultiAz() {
            return this.multiAz;
        }

        public final void setMultiAz(Boolean multiAz) {
            this.multiAz = multiAz;
        }

        @Override
        public final Builder multiAz(Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            if (this.readReplicaIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.readReplicaIdentifiers;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = StringListCopier.copy(readReplicaIdentifiers);
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = StringListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final List<AwsRdsDbInstanceVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            List<AwsRdsDbInstanceVpcSecurityGroup.Builder> result = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (AwsRdsDbInstanceVpcSecurityGroup)((AwsRdsDbInstanceVpcSecurityGroup.Builder)AwsRdsDbInstanceVpcSecurityGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final List<AwsRdsDbClusterAssociatedRole.Builder> getAssociatedRoles() {
            List<AwsRdsDbClusterAssociatedRole.Builder> result = AwsRdsDbClusterAssociatedRolesCopier.copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<AwsRdsDbClusterAssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AwsRdsDbClusterAssociatedRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<AwsRdsDbClusterAssociatedRole> associatedRoles) {
            this.associatedRoles = AwsRdsDbClusterAssociatedRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AwsRdsDbClusterAssociatedRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AwsRdsDbClusterAssociatedRole.Builder> ... associatedRoles) {
            this.associatedRoles(Stream.of(associatedRoles).map(c -> (AwsRdsDbClusterAssociatedRole)((AwsRdsDbClusterAssociatedRole.Builder)AwsRdsDbClusterAssociatedRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(String clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Collection<String> getEnabledCloudWatchLogsExports() {
            if (this.enabledCloudWatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledCloudWatchLogsExports;
        }

        public final void setEnabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
        }

        @Override
        public final Builder enabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudWatchLogsExports(String ... enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports(Arrays.asList(enabledCloudWatchLogsExports));
            return this;
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Boolean getHttpEndpointEnabled() {
            return this.httpEndpointEnabled;
        }

        public final void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
        }

        @Override
        public final Builder httpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
            return this;
        }

        public final String getActivityStreamStatus() {
            return this.activityStreamStatus;
        }

        public final void setActivityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
        }

        @Override
        public final Builder activityStreamStatus(String activityStreamStatus) {
            this.activityStreamStatus = activityStreamStatus;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Boolean getCrossAccountClone() {
            return this.crossAccountClone;
        }

        public final void setCrossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
        }

        @Override
        public final Builder crossAccountClone(Boolean crossAccountClone) {
            this.crossAccountClone = crossAccountClone;
            return this;
        }

        public final List<AwsRdsDbDomainMembership.Builder> getDomainMemberships() {
            List<AwsRdsDbDomainMembership.Builder> result = AwsRdsDbDomainMembershipsCopier.copyToBuilder(this.domainMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainMemberships(Collection<AwsRdsDbDomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copyFromBuilder(domainMemberships);
        }

        @Override
        public final Builder domainMemberships(Collection<AwsRdsDbDomainMembership> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(AwsRdsDbDomainMembership ... domainMemberships) {
            this.domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder> ... domainMemberships) {
            this.domainMemberships(Stream.of(domainMemberships).map(c -> (AwsRdsDbDomainMembership)((AwsRdsDbDomainMembership.Builder)AwsRdsDbDomainMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterParameterGroup() {
            return this.dbClusterParameterGroup;
        }

        public final void setDbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final String getDbSubnetGroup() {
            return this.dbSubnetGroup;
        }

        public final void setDbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final List<AwsRdsDbClusterOptionGroupMembership.Builder> getDbClusterOptionGroupMemberships() {
            List<AwsRdsDbClusterOptionGroupMembership.Builder> result = AwsRdsDbClusterOptionGroupMembershipsCopier.copyToBuilder(this.dbClusterOptionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterOptionGroupMemberships(Collection<AwsRdsDbClusterOptionGroupMembership.BuilderImpl> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = AwsRdsDbClusterOptionGroupMembershipsCopier.copyFromBuilder(dbClusterOptionGroupMemberships);
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(Collection<AwsRdsDbClusterOptionGroupMembership> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = AwsRdsDbClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(AwsRdsDbClusterOptionGroupMembership ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(Consumer<AwsRdsDbClusterOptionGroupMembership.Builder> ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Stream.of(dbClusterOptionGroupMemberships).map(c -> (AwsRdsDbClusterOptionGroupMembership)((AwsRdsDbClusterOptionGroupMembership.Builder)AwsRdsDbClusterOptionGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final List<AwsRdsDbClusterMember.Builder> getDbClusterMembers() {
            List<AwsRdsDbClusterMember.Builder> result = AwsRdsDbClusterMembersCopier.copyToBuilder(this.dbClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbClusterMembers(Collection<AwsRdsDbClusterMember.BuilderImpl> dbClusterMembers) {
            this.dbClusterMembers = AwsRdsDbClusterMembersCopier.copyFromBuilder(dbClusterMembers);
        }

        @Override
        public final Builder dbClusterMembers(Collection<AwsRdsDbClusterMember> dbClusterMembers) {
            this.dbClusterMembers = AwsRdsDbClusterMembersCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(AwsRdsDbClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(Consumer<AwsRdsDbClusterMember.Builder> ... dbClusterMembers) {
            this.dbClusterMembers(Stream.of(dbClusterMembers).map(c -> (AwsRdsDbClusterMember)((AwsRdsDbClusterMember.Builder)AwsRdsDbClusterMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public AwsRdsDbClusterDetails build() {
            return new AwsRdsDbClusterDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsRdsDbClusterDetails> {
        public Builder allocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder databaseName(String var1);

        public Builder status(String var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder customEndpoints(Collection<String> var1);

        public Builder customEndpoints(String ... var1);

        public Builder multiAz(Boolean var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder readReplicaIdentifiers(Collection<String> var1);

        public Builder readReplicaIdentifiers(String ... var1);

        public Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> var1);

        public Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup ... var1);

        public Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder> ... var1);

        public Builder hostedZoneId(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder associatedRoles(Collection<AwsRdsDbClusterAssociatedRole> var1);

        public Builder associatedRoles(AwsRdsDbClusterAssociatedRole ... var1);

        public Builder associatedRoles(Consumer<AwsRdsDbClusterAssociatedRole.Builder> ... var1);

        public Builder clusterCreateTime(String var1);

        public Builder enabledCloudWatchLogsExports(Collection<String> var1);

        public Builder enabledCloudWatchLogsExports(String ... var1);

        public Builder engineMode(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder httpEndpointEnabled(Boolean var1);

        public Builder activityStreamStatus(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder crossAccountClone(Boolean var1);

        public Builder domainMemberships(Collection<AwsRdsDbDomainMembership> var1);

        public Builder domainMemberships(AwsRdsDbDomainMembership ... var1);

        public Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder> ... var1);

        public Builder dbClusterParameterGroup(String var1);

        public Builder dbSubnetGroup(String var1);

        public Builder dbClusterOptionGroupMemberships(Collection<AwsRdsDbClusterOptionGroupMembership> var1);

        public Builder dbClusterOptionGroupMemberships(AwsRdsDbClusterOptionGroupMembership ... var1);

        public Builder dbClusterOptionGroupMemberships(Consumer<AwsRdsDbClusterOptionGroupMembership.Builder> ... var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterMembers(Collection<AwsRdsDbClusterMember> var1);

        public Builder dbClusterMembers(AwsRdsDbClusterMember ... var1);

        public Builder dbClusterMembers(Consumer<AwsRdsDbClusterMember.Builder> ... var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);
    }
}

