/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsSecurityFindingFilters;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInsightRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, UpdateInsightRequest> {
    private static final SdkField<String> INSIGHT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightArn").getter(UpdateInsightRequest.getter(UpdateInsightRequest::insightArn)).setter(UpdateInsightRequest.setter(Builder::insightArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("InsightArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateInsightRequest.getter(UpdateInsightRequest::name)).setter(UpdateInsightRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AwsSecurityFindingFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(UpdateInsightRequest.getter(UpdateInsightRequest::filters)).setter(UpdateInsightRequest.setter(Builder::filters)).constructor(AwsSecurityFindingFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<String> GROUP_BY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupByAttribute").getter(UpdateInsightRequest.getter(UpdateInsightRequest::groupByAttribute)).setter(UpdateInsightRequest.setter(Builder::groupByAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSIGHT_ARN_FIELD, NAME_FIELD, FILTERS_FIELD, GROUP_BY_ATTRIBUTE_FIELD));
    private final String insightArn;
    private final String name;
    private final AwsSecurityFindingFilters filters;
    private final String groupByAttribute;

    private UpdateInsightRequest(BuilderImpl builder) {
        super(builder);
        this.insightArn = builder.insightArn;
        this.name = builder.name;
        this.filters = builder.filters;
        this.groupByAttribute = builder.groupByAttribute;
    }

    public final String insightArn() {
        return this.insightArn;
    }

    public final String name() {
        return this.name;
    }

    public final AwsSecurityFindingFilters filters() {
        return this.filters;
    }

    public final String groupByAttribute() {
        return this.groupByAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.insightArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupByAttribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInsightRequest)) {
            return false;
        }
        UpdateInsightRequest other = (UpdateInsightRequest)((Object)obj);
        return Objects.equals(this.insightArn(), other.insightArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.groupByAttribute(), other.groupByAttribute());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInsightRequest").add("InsightArn", (Object)this.insightArn()).add("Name", (Object)this.name()).add("Filters", (Object)this.filters()).add("GroupByAttribute", (Object)this.groupByAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InsightArn": {
                return Optional.ofNullable(clazz.cast(this.insightArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "GroupByAttribute": {
                return Optional.ofNullable(clazz.cast(this.groupByAttribute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInsightRequest, T> g) {
        return obj -> g.apply((UpdateInsightRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String insightArn;
        private String name;
        private AwsSecurityFindingFilters filters;
        private String groupByAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInsightRequest model) {
            super(model);
            this.insightArn(model.insightArn);
            this.name(model.name);
            this.filters(model.filters);
            this.groupByAttribute(model.groupByAttribute);
        }

        public final String getInsightArn() {
            return this.insightArn;
        }

        public final void setInsightArn(String insightArn) {
            this.insightArn = insightArn;
        }

        @Override
        @Transient
        public final Builder insightArn(String insightArn) {
            this.insightArn = insightArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsSecurityFindingFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(AwsSecurityFindingFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        @Transient
        public final Builder filters(AwsSecurityFindingFilters filters) {
            this.filters = filters;
            return this;
        }

        public final String getGroupByAttribute() {
            return this.groupByAttribute;
        }

        public final void setGroupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
        }

        @Override
        @Transient
        public final Builder groupByAttribute(String groupByAttribute) {
            this.groupByAttribute = groupByAttribute;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInsightRequest build() {
            return new UpdateInsightRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInsightRequest> {
        public Builder insightArn(String var1);

        public Builder name(String var1);

        public Builder filters(AwsSecurityFindingFilters var1);

        default public Builder filters(Consumer<AwsSecurityFindingFilters.Builder> filters) {
            return this.filters((AwsSecurityFindingFilters)((AwsSecurityFindingFilters.Builder)AwsSecurityFindingFilters.builder().applyMutation(filters)).build());
        }

        public Builder groupByAttribute(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

