/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Partition {
    AWS("aws"),
    AWS_CN("aws-cn"),
    AWS_US_GOV("aws-us-gov"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Partition> VALUE_MAP;
    private final String value;

    private Partition(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Partition fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Partition> knownValues() {
        EnumSet<Partition> knownValues = EnumSet.allOf(Partition.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Partition.class, Partition::toString);
    }
}

