/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum WorkflowStatus {
    NEW("NEW"),
    NOTIFIED("NOTIFIED"),
    RESOLVED("RESOLVED"),
    SUPPRESSED("SUPPRESSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private WorkflowStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkflowStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(WorkflowStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkflowStatus> knownValues() {
        return Stream.of(WorkflowStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

