/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RecordState {
    ACTIVE("ACTIVE"),
    ARCHIVED("ARCHIVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RecordState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RecordState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordState> knownValues() {
        return Stream.of(RecordState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

