/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProductsRequest
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, DescribeProductsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeProductsRequest.getter(DescribeProductsRequest::nextToken)).setter(DescribeProductsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeProductsRequest.getter(DescribeProductsRequest::maxResults)).setter(DescribeProductsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> PRODUCT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductArn").getter(DescribeProductsRequest.getter(DescribeProductsRequest::productArn)).setter(DescribeProductsRequest.setter(Builder::productArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ProductArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, PRODUCT_ARN_FIELD));
    private final String nextToken;
    private final Integer maxResults;
    private final String productArn;

    private DescribeProductsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.productArn = builder.productArn;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String productArn() {
        return this.productArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.productArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProductsRequest)) {
            return false;
        }
        DescribeProductsRequest other = (DescribeProductsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.productArn(), other.productArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeProductsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ProductArn", (Object)this.productArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ProductArn": {
                return Optional.ofNullable(clazz.cast(this.productArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProductsRequest, T> g) {
        return obj -> g.apply((DescribeProductsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String productArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProductsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.productArn(model.productArn);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getProductArn() {
            return this.productArn;
        }

        @Override
        public final Builder productArn(String productArn) {
            this.productArn = productArn;
            return this;
        }

        public final void setProductArn(String productArn) {
            this.productArn = productArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeProductsRequest build() {
            return new DescribeProductsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeProductsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder productArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

