/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerAccessLog;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionDraining;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings;
import software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerCrossZoneLoadBalancing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsElbLoadBalancerAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsElbLoadBalancerAttributes> {
    private static final SdkField<AwsElbLoadBalancerAccessLog> ACCESS_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessLog").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::accessLog)).setter(AwsElbLoadBalancerAttributes.setter(Builder::accessLog)).constructor(AwsElbLoadBalancerAccessLog::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessLog").build()}).build();
    private static final SdkField<AwsElbLoadBalancerConnectionDraining> CONNECTION_DRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionDraining").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::connectionDraining)).setter(AwsElbLoadBalancerAttributes.setter(Builder::connectionDraining)).constructor(AwsElbLoadBalancerConnectionDraining::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionDraining").build()}).build();
    private static final SdkField<AwsElbLoadBalancerConnectionSettings> CONNECTION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConnectionSettings").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::connectionSettings)).setter(AwsElbLoadBalancerAttributes.setter(Builder::connectionSettings)).constructor(AwsElbLoadBalancerConnectionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionSettings").build()}).build();
    private static final SdkField<AwsElbLoadBalancerCrossZoneLoadBalancing> CROSS_ZONE_LOAD_BALANCING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CrossZoneLoadBalancing").getter(AwsElbLoadBalancerAttributes.getter(AwsElbLoadBalancerAttributes::crossZoneLoadBalancing)).setter(AwsElbLoadBalancerAttributes.setter(Builder::crossZoneLoadBalancing)).constructor(AwsElbLoadBalancerCrossZoneLoadBalancing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossZoneLoadBalancing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_FIELD, CONNECTION_DRAINING_FIELD, CONNECTION_SETTINGS_FIELD, CROSS_ZONE_LOAD_BALANCING_FIELD));
    private static final long serialVersionUID = 1L;
    private final AwsElbLoadBalancerAccessLog accessLog;
    private final AwsElbLoadBalancerConnectionDraining connectionDraining;
    private final AwsElbLoadBalancerConnectionSettings connectionSettings;
    private final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;

    private AwsElbLoadBalancerAttributes(BuilderImpl builder) {
        this.accessLog = builder.accessLog;
        this.connectionDraining = builder.connectionDraining;
        this.connectionSettings = builder.connectionSettings;
        this.crossZoneLoadBalancing = builder.crossZoneLoadBalancing;
    }

    public final AwsElbLoadBalancerAccessLog accessLog() {
        return this.accessLog;
    }

    public final AwsElbLoadBalancerConnectionDraining connectionDraining() {
        return this.connectionDraining;
    }

    public final AwsElbLoadBalancerConnectionSettings connectionSettings() {
        return this.connectionSettings;
    }

    public final AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing() {
        return this.crossZoneLoadBalancing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionDraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossZoneLoadBalancing());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerAttributes)) {
            return false;
        }
        AwsElbLoadBalancerAttributes other = (AwsElbLoadBalancerAttributes)obj;
        return Objects.equals(this.accessLog(), other.accessLog()) && Objects.equals(this.connectionDraining(), other.connectionDraining()) && Objects.equals(this.connectionSettings(), other.connectionSettings()) && Objects.equals(this.crossZoneLoadBalancing(), other.crossZoneLoadBalancing());
    }

    public final String toString() {
        return ToString.builder((String)"AwsElbLoadBalancerAttributes").add("AccessLog", (Object)this.accessLog()).add("ConnectionDraining", (Object)this.connectionDraining()).add("ConnectionSettings", (Object)this.connectionSettings()).add("CrossZoneLoadBalancing", (Object)this.crossZoneLoadBalancing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessLog": {
                return Optional.ofNullable(clazz.cast(this.accessLog()));
            }
            case "ConnectionDraining": {
                return Optional.ofNullable(clazz.cast(this.connectionDraining()));
            }
            case "ConnectionSettings": {
                return Optional.ofNullable(clazz.cast(this.connectionSettings()));
            }
            case "CrossZoneLoadBalancing": {
                return Optional.ofNullable(clazz.cast(this.crossZoneLoadBalancing()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerAttributes, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsElbLoadBalancerAccessLog accessLog;
        private AwsElbLoadBalancerConnectionDraining connectionDraining;
        private AwsElbLoadBalancerConnectionSettings connectionSettings;
        private AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerAttributes model) {
            this.accessLog(model.accessLog);
            this.connectionDraining(model.connectionDraining);
            this.connectionSettings(model.connectionSettings);
            this.crossZoneLoadBalancing(model.crossZoneLoadBalancing);
        }

        public final AwsElbLoadBalancerAccessLog.Builder getAccessLog() {
            return this.accessLog != null ? this.accessLog.toBuilder() : null;
        }

        @Override
        public final Builder accessLog(AwsElbLoadBalancerAccessLog accessLog) {
            this.accessLog = accessLog;
            return this;
        }

        public final void setAccessLog(AwsElbLoadBalancerAccessLog.BuilderImpl accessLog) {
            this.accessLog = accessLog != null ? accessLog.build() : null;
        }

        public final AwsElbLoadBalancerConnectionDraining.Builder getConnectionDraining() {
            return this.connectionDraining != null ? this.connectionDraining.toBuilder() : null;
        }

        @Override
        public final Builder connectionDraining(AwsElbLoadBalancerConnectionDraining connectionDraining) {
            this.connectionDraining = connectionDraining;
            return this;
        }

        public final void setConnectionDraining(AwsElbLoadBalancerConnectionDraining.BuilderImpl connectionDraining) {
            this.connectionDraining = connectionDraining != null ? connectionDraining.build() : null;
        }

        public final AwsElbLoadBalancerConnectionSettings.Builder getConnectionSettings() {
            return this.connectionSettings != null ? this.connectionSettings.toBuilder() : null;
        }

        @Override
        public final Builder connectionSettings(AwsElbLoadBalancerConnectionSettings connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        public final void setConnectionSettings(AwsElbLoadBalancerConnectionSettings.BuilderImpl connectionSettings) {
            this.connectionSettings = connectionSettings != null ? connectionSettings.build() : null;
        }

        public final AwsElbLoadBalancerCrossZoneLoadBalancing.Builder getCrossZoneLoadBalancing() {
            return this.crossZoneLoadBalancing != null ? this.crossZoneLoadBalancing.toBuilder() : null;
        }

        @Override
        public final Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing;
            return this;
        }

        public final void setCrossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing.BuilderImpl crossZoneLoadBalancing) {
            this.crossZoneLoadBalancing = crossZoneLoadBalancing != null ? crossZoneLoadBalancing.build() : null;
        }

        public AwsElbLoadBalancerAttributes build() {
            return new AwsElbLoadBalancerAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsElbLoadBalancerAttributes> {
        public Builder accessLog(AwsElbLoadBalancerAccessLog var1);

        default public Builder accessLog(Consumer<AwsElbLoadBalancerAccessLog.Builder> accessLog) {
            return this.accessLog((AwsElbLoadBalancerAccessLog)((AwsElbLoadBalancerAccessLog.Builder)AwsElbLoadBalancerAccessLog.builder().applyMutation(accessLog)).build());
        }

        public Builder connectionDraining(AwsElbLoadBalancerConnectionDraining var1);

        default public Builder connectionDraining(Consumer<AwsElbLoadBalancerConnectionDraining.Builder> connectionDraining) {
            return this.connectionDraining((AwsElbLoadBalancerConnectionDraining)((AwsElbLoadBalancerConnectionDraining.Builder)AwsElbLoadBalancerConnectionDraining.builder().applyMutation(connectionDraining)).build());
        }

        public Builder connectionSettings(AwsElbLoadBalancerConnectionSettings var1);

        default public Builder connectionSettings(Consumer<AwsElbLoadBalancerConnectionSettings.Builder> connectionSettings) {
            return this.connectionSettings((AwsElbLoadBalancerConnectionSettings)((AwsElbLoadBalancerConnectionSettings.Builder)AwsElbLoadBalancerConnectionSettings.builder().applyMutation(connectionSettings)).build());
        }

        public Builder crossZoneLoadBalancing(AwsElbLoadBalancerCrossZoneLoadBalancing var1);

        default public Builder crossZoneLoadBalancing(Consumer<AwsElbLoadBalancerCrossZoneLoadBalancing.Builder> crossZoneLoadBalancing) {
            return this.crossZoneLoadBalancing((AwsElbLoadBalancerCrossZoneLoadBalancing)((AwsElbLoadBalancerCrossZoneLoadBalancing.Builder)AwsElbLoadBalancerCrossZoneLoadBalancing.builder().applyMutation(crossZoneLoadBalancing)).build());
        }
    }
}

