/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsCloudFrontDistributionLogging
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsCloudFrontDistributionLogging> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(AwsCloudFrontDistributionLogging.getter(AwsCloudFrontDistributionLogging::bucket)).setter(AwsCloudFrontDistributionLogging.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(AwsCloudFrontDistributionLogging.getter(AwsCloudFrontDistributionLogging::enabled)).setter(AwsCloudFrontDistributionLogging.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<Boolean> INCLUDE_COOKIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeCookies").getter(AwsCloudFrontDistributionLogging.getter(AwsCloudFrontDistributionLogging::includeCookies)).setter(AwsCloudFrontDistributionLogging.setter(Builder::includeCookies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeCookies").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(AwsCloudFrontDistributionLogging.getter(AwsCloudFrontDistributionLogging::prefix)).setter(AwsCloudFrontDistributionLogging.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, ENABLED_FIELD, INCLUDE_COOKIES_FIELD, PREFIX_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final Boolean enabled;
    private final Boolean includeCookies;
    private final String prefix;

    private AwsCloudFrontDistributionLogging(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.enabled = builder.enabled;
        this.includeCookies = builder.includeCookies;
        this.prefix = builder.prefix;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Boolean includeCookies() {
        return this.includeCookies;
    }

    public final String prefix() {
        return this.prefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeCookies());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionLogging)) {
            return false;
        }
        AwsCloudFrontDistributionLogging other = (AwsCloudFrontDistributionLogging)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.includeCookies(), other.includeCookies()) && Objects.equals(this.prefix(), other.prefix());
    }

    public final String toString() {
        return ToString.builder((String)"AwsCloudFrontDistributionLogging").add("Bucket", (Object)this.bucket()).add("Enabled", (Object)this.enabled()).add("IncludeCookies", (Object)this.includeCookies()).add("Prefix", (Object)this.prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "IncludeCookies": {
                return Optional.ofNullable(clazz.cast(this.includeCookies()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionLogging, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionLogging)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private Boolean enabled;
        private Boolean includeCookies;
        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionLogging model) {
            this.bucket(model.bucket);
            this.enabled(model.enabled);
            this.includeCookies(model.includeCookies);
            this.prefix(model.prefix);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Boolean getIncludeCookies() {
            return this.includeCookies;
        }

        @Override
        public final Builder includeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
            return this;
        }

        public final void setIncludeCookies(Boolean includeCookies) {
            this.includeCookies = includeCookies;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public AwsCloudFrontDistributionLogging build() {
            return new AwsCloudFrontDistributionLogging(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsCloudFrontDistributionLogging> {
        public Builder bucket(String var1);

        public Builder enabled(Boolean var1);

        public Builder includeCookies(Boolean var1);

        public Builder prefix(String var1);
    }
}

