/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.schemas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiscovererState {
    STARTED("STARTED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiscovererState> VALUE_MAP;
    private final String value;

    private DiscovererState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiscovererState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiscovererState> knownValues() {
        EnumSet<DiscovererState> knownValues = EnumSet.allOf(DiscovererState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiscovererState.class, DiscovererState::toString);
    }
}

