/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetRecordResponse extends SageMakerFeatureStoreRuntimeResponse implements
        ToCopyableBuilder<BatchGetRecordResponse.Builder, BatchGetRecordResponse> {
    private static final SdkField<List<BatchGetRecordResultDetail>> RECORDS_FIELD = SdkField
            .<List<BatchGetRecordResultDetail>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(BatchGetRecordResponse::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRecordResultDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRecordResultDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetRecordError>> ERRORS_FIELD = SdkField
            .<List<BatchGetRecordError>> builder(MarshallingType.LIST)
            .memberName("Errors")
            .getter(getter(BatchGetRecordResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRecordError> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRecordError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchGetRecordIdentifier>> UNPROCESSED_IDENTIFIERS_FIELD = SdkField
            .<List<BatchGetRecordIdentifier>> builder(MarshallingType.LIST)
            .memberName("UnprocessedIdentifiers")
            .getter(getter(BatchGetRecordResponse::unprocessedIdentifiers))
            .setter(setter(Builder::unprocessedIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetRecordIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetRecordIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD, ERRORS_FIELD,
            UNPROCESSED_IDENTIFIERS_FIELD));

    private final List<BatchGetRecordResultDetail> records;

    private final List<BatchGetRecordError> errors;

    private final List<BatchGetRecordIdentifier> unprocessedIdentifiers;

    private BatchGetRecordResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.errors = builder.errors;
        this.unprocessedIdentifiers = builder.unprocessedIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Records you requested to be retrieved in batch.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return A list of Records you requested to be retrieved in batch.
     */
    public final List<BatchGetRecordResultDetail> records() {
        return records;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of errors that have occurred when retrieving a batch of Records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of errors that have occurred when retrieving a batch of Records.
     */
    public final List<BatchGetRecordError> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedIdentifiers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedIdentifiers() {
        return unprocessedIdentifiers != null && !(unprocessedIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A unprocessed list of <code>FeatureGroup</code> names, with their corresponding <code>RecordIdentifier</code>
     * value, and Feature name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedIdentifiers} method.
     * </p>
     * 
     * @return A unprocessed list of <code>FeatureGroup</code> names, with their corresponding
     *         <code>RecordIdentifier</code> value, and Feature name.
     */
    public final List<BatchGetRecordIdentifier> unprocessedIdentifiers() {
        return unprocessedIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedIdentifiers() ? unprocessedIdentifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetRecordResponse)) {
            return false;
        }
        BatchGetRecordResponse other = (BatchGetRecordResponse) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors())
                && hasUnprocessedIdentifiers() == other.hasUnprocessedIdentifiers()
                && Objects.equals(unprocessedIdentifiers(), other.unprocessedIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetRecordResponse").add("Records", hasRecords() ? records() : null)
                .add("Errors", hasErrors() ? errors() : null)
                .add("UnprocessedIdentifiers", hasUnprocessedIdentifiers() ? unprocessedIdentifiers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "Errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "UnprocessedIdentifiers":
            return Optional.ofNullable(clazz.cast(unprocessedIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetRecordResponse, T> g) {
        return obj -> g.apply((BatchGetRecordResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetRecordResponse> {
        /**
         * <p>
         * A list of Records you requested to be retrieved in batch.
         * </p>
         * 
         * @param records
         *        A list of Records you requested to be retrieved in batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<BatchGetRecordResultDetail> records);

        /**
         * <p>
         * A list of Records you requested to be retrieved in batch.
         * </p>
         * 
         * @param records
         *        A list of Records you requested to be retrieved in batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(BatchGetRecordResultDetail... records);

        /**
         * <p>
         * A list of Records you requested to be retrieved in batch.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.Builder#build()}
         * is called immediately and its result is passed to {@link #records(List<BatchGetRecordResultDetail>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordResultDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<BatchGetRecordResultDetail>)
         */
        Builder records(Consumer<BatchGetRecordResultDetail.Builder>... records);

        /**
         * <p>
         * A list of errors that have occurred when retrieving a batch of Records.
         * </p>
         * 
         * @param errors
         *        A list of errors that have occurred when retrieving a batch of Records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<BatchGetRecordError> errors);

        /**
         * <p>
         * A list of errors that have occurred when retrieving a batch of Records.
         * </p>
         * 
         * @param errors
         *        A list of errors that have occurred when retrieving a batch of Records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(BatchGetRecordError... errors);

        /**
         * <p>
         * A list of errors that have occurred when retrieving a batch of Records.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError.Builder#build()}
         * is called immediately and its result is passed to {@link #errors(List<BatchGetRecordError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<BatchGetRecordError>)
         */
        Builder errors(Consumer<BatchGetRecordError.Builder>... errors);

        /**
         * <p>
         * A unprocessed list of <code>FeatureGroup</code> names, with their corresponding <code>RecordIdentifier</code>
         * value, and Feature name.
         * </p>
         * 
         * @param unprocessedIdentifiers
         *        A unprocessed list of <code>FeatureGroup</code> names, with their corresponding
         *        <code>RecordIdentifier</code> value, and Feature name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentifiers(Collection<BatchGetRecordIdentifier> unprocessedIdentifiers);

        /**
         * <p>
         * A unprocessed list of <code>FeatureGroup</code> names, with their corresponding <code>RecordIdentifier</code>
         * value, and Feature name.
         * </p>
         * 
         * @param unprocessedIdentifiers
         *        A unprocessed list of <code>FeatureGroup</code> names, with their corresponding
         *        <code>RecordIdentifier</code> value, and Feature name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedIdentifiers(BatchGetRecordIdentifier... unprocessedIdentifiers);

        /**
         * <p>
         * A unprocessed list of <code>FeatureGroup</code> names, with their corresponding <code>RecordIdentifier</code>
         * value, and Feature name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedIdentifiers(List<BatchGetRecordIdentifier>)}.
         * 
         * @param unprocessedIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model.BatchGetRecordIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedIdentifiers(java.util.Collection<BatchGetRecordIdentifier>)
         */
        Builder unprocessedIdentifiers(Consumer<BatchGetRecordIdentifier.Builder>... unprocessedIdentifiers);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeResponse.BuilderImpl implements Builder {
        private List<BatchGetRecordResultDetail> records = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetRecordError> errors = DefaultSdkAutoConstructList.getInstance();

        private List<BatchGetRecordIdentifier> unprocessedIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetRecordResponse model) {
            super(model);
            records(model.records);
            errors(model.errors);
            unprocessedIdentifiers(model.unprocessedIdentifiers);
        }

        public final List<BatchGetRecordResultDetail.Builder> getRecords() {
            List<BatchGetRecordResultDetail.Builder> result = BatchGetRecordResultDetailsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<BatchGetRecordResultDetail.BuilderImpl> records) {
            this.records = BatchGetRecordResultDetailsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<BatchGetRecordResultDetail> records) {
            this.records = BatchGetRecordResultDetailsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(BatchGetRecordResultDetail... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<BatchGetRecordResultDetail.Builder>... records) {
            records(Stream.of(records).map(c -> BatchGetRecordResultDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRecordError.Builder> getErrors() {
            List<BatchGetRecordError.Builder> result = BatchGetRecordErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetRecordError.BuilderImpl> errors) {
            this.errors = BatchGetRecordErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetRecordError> errors) {
            this.errors = BatchGetRecordErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetRecordError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetRecordError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> BatchGetRecordError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetRecordIdentifier.Builder> getUnprocessedIdentifiers() {
            List<BatchGetRecordIdentifier.Builder> result = UnprocessedIdentifiersCopier
                    .copyToBuilder(this.unprocessedIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedIdentifiers(Collection<BatchGetRecordIdentifier.BuilderImpl> unprocessedIdentifiers) {
            this.unprocessedIdentifiers = UnprocessedIdentifiersCopier.copyFromBuilder(unprocessedIdentifiers);
        }

        @Override
        public final Builder unprocessedIdentifiers(Collection<BatchGetRecordIdentifier> unprocessedIdentifiers) {
            this.unprocessedIdentifiers = UnprocessedIdentifiersCopier.copy(unprocessedIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentifiers(BatchGetRecordIdentifier... unprocessedIdentifiers) {
            unprocessedIdentifiers(Arrays.asList(unprocessedIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedIdentifiers(Consumer<BatchGetRecordIdentifier.Builder>... unprocessedIdentifiers) {
            unprocessedIdentifiers(Stream.of(unprocessedIdentifiers)
                    .map(c -> BatchGetRecordIdentifier.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetRecordResponse build() {
            return new BatchGetRecordResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
