/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakerfeaturestoreruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecordRequest extends SageMakerFeatureStoreRuntimeRequest implements
        ToCopyableBuilder<GetRecordRequest.Builder, GetRecordRequest> {
    private static final SdkField<String> FEATURE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeatureGroupName").getter(getter(GetRecordRequest::featureGroupName))
            .setter(setter(Builder::featureGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FeatureGroupName").build()).build();

    private static final SdkField<String> RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RecordIdentifierValueAsString")
            .getter(getter(GetRecordRequest::recordIdentifierValueAsString))
            .setter(setter(Builder::recordIdentifierValueAsString))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("RecordIdentifierValueAsString")
                    .build()).build();

    private static final SdkField<List<String>> FEATURE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FeatureNames")
            .getter(getter(GetRecordRequest::featureNames))
            .setter(setter(Builder::featureNames))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FeatureName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXPIRATION_TIME_RESPONSE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ExpirationTimeResponse")
            .getter(getter(GetRecordRequest::expirationTimeResponseAsString))
            .setter(setter(Builder::expirationTimeResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ExpirationTimeResponse").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_GROUP_NAME_FIELD,
            RECORD_IDENTIFIER_VALUE_AS_STRING_FIELD, FEATURE_NAMES_FIELD, EXPIRATION_TIME_RESPONSE_FIELD));

    private final String featureGroupName;

    private final String recordIdentifierValueAsString;

    private final List<String> featureNames;

    private final String expirationTimeResponse;

    private GetRecordRequest(BuilderImpl builder) {
        super(builder);
        this.featureGroupName = builder.featureGroupName;
        this.recordIdentifierValueAsString = builder.recordIdentifierValueAsString;
        this.featureNames = builder.featureNames;
        this.expirationTimeResponse = builder.expirationTimeResponse;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the feature group from which you want to retrieve a record.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the feature group from which you want to retrieve a record.
     */
    public final String featureGroupName() {
        return featureGroupName;
    }

    /**
     * <p>
     * The value that corresponds to <code>RecordIdentifier</code> type and uniquely identifies the record in the
     * <code>FeatureGroup</code>.
     * </p>
     * 
     * @return The value that corresponds to <code>RecordIdentifier</code> type and uniquely identifies the record in
     *         the <code>FeatureGroup</code>.
     */
    public final String recordIdentifierValueAsString() {
        return recordIdentifierValueAsString;
    }

    /**
     * For responses, this returns true if the service returned a value for the FeatureNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFeatureNames() {
        return featureNames != null && !(featureNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of names of Features to be retrieved. If not specified, the latest value for all the Features are returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatureNames} method.
     * </p>
     * 
     * @return List of names of Features to be retrieved. If not specified, the latest value for all the Features are
     *         returned.
     */
    public final List<String> featureNames() {
        return featureNames;
    }

    /**
     * <p>
     * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code> will
     * return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     * <code>GetRecord</code> will return null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationTimeResponse} will return {@link ExpirationTimeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationTimeResponseAsString}.
     * </p>
     * 
     * @return Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code>
     *         will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     *         <code>GetRecord</code> will return null.
     * @see ExpirationTimeResponse
     */
    public final ExpirationTimeResponse expirationTimeResponse() {
        return ExpirationTimeResponse.fromValue(expirationTimeResponse);
    }

    /**
     * <p>
     * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code> will
     * return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     * <code>GetRecord</code> will return null.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expirationTimeResponse} will return {@link ExpirationTimeResponse#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #expirationTimeResponseAsString}.
     * </p>
     * 
     * @return Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code>
     *         will return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
     *         <code>GetRecord</code> will return null.
     * @see ExpirationTimeResponse
     */
    public final String expirationTimeResponseAsString() {
        return expirationTimeResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(featureGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(recordIdentifierValueAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatureNames() ? featureNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(expirationTimeResponseAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordRequest)) {
            return false;
        }
        GetRecordRequest other = (GetRecordRequest) obj;
        return Objects.equals(featureGroupName(), other.featureGroupName())
                && Objects.equals(recordIdentifierValueAsString(), other.recordIdentifierValueAsString())
                && hasFeatureNames() == other.hasFeatureNames() && Objects.equals(featureNames(), other.featureNames())
                && Objects.equals(expirationTimeResponseAsString(), other.expirationTimeResponseAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecordRequest").add("FeatureGroupName", featureGroupName())
                .add("RecordIdentifierValueAsString", recordIdentifierValueAsString())
                .add("FeatureNames", hasFeatureNames() ? featureNames() : null)
                .add("ExpirationTimeResponse", expirationTimeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FeatureGroupName":
            return Optional.ofNullable(clazz.cast(featureGroupName()));
        case "RecordIdentifierValueAsString":
            return Optional.ofNullable(clazz.cast(recordIdentifierValueAsString()));
        case "FeatureNames":
            return Optional.ofNullable(clazz.cast(featureNames()));
        case "ExpirationTimeResponse":
            return Optional.ofNullable(clazz.cast(expirationTimeResponseAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRecordRequest, T> g) {
        return obj -> g.apply((GetRecordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerFeatureStoreRuntimeRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecordRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the feature group from which you want to retrieve a record.
         * </p>
         * 
         * @param featureGroupName
         *        The name or Amazon Resource Name (ARN) of the feature group from which you want to retrieve a record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureGroupName(String featureGroupName);

        /**
         * <p>
         * The value that corresponds to <code>RecordIdentifier</code> type and uniquely identifies the record in the
         * <code>FeatureGroup</code>.
         * </p>
         * 
         * @param recordIdentifierValueAsString
         *        The value that corresponds to <code>RecordIdentifier</code> type and uniquely identifies the record in
         *        the <code>FeatureGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIdentifierValueAsString(String recordIdentifierValueAsString);

        /**
         * <p>
         * List of names of Features to be retrieved. If not specified, the latest value for all the Features are
         * returned.
         * </p>
         * 
         * @param featureNames
         *        List of names of Features to be retrieved. If not specified, the latest value for all the Features are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureNames(Collection<String> featureNames);

        /**
         * <p>
         * List of names of Features to be retrieved. If not specified, the latest value for all the Features are
         * returned.
         * </p>
         * 
         * @param featureNames
         *        List of names of Features to be retrieved. If not specified, the latest value for all the Features are
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featureNames(String... featureNames);

        /**
         * <p>
         * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code> will
         * return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
         * <code>GetRecord</code> will return null.
         * </p>
         * 
         * @param expirationTimeResponse
         *        Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
         *        <code>GetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
         *        <code>Disabled</code> and null, <code>GetRecord</code> will return null.
         * @see ExpirationTimeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationTimeResponse
         */
        Builder expirationTimeResponse(String expirationTimeResponse);

        /**
         * <p>
         * Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>, <code>GetRecord</code> will
         * return the value of <code>ExpiresAt</code>, if it is not null. If <code>Disabled</code> and null,
         * <code>GetRecord</code> will return null.
         * </p>
         * 
         * @param expirationTimeResponse
         *        Parameter to request <code>ExpiresAt</code> in response. If <code>Enabled</code>,
         *        <code>GetRecord</code> will return the value of <code>ExpiresAt</code>, if it is not null. If
         *        <code>Disabled</code> and null, <code>GetRecord</code> will return null.
         * @see ExpirationTimeResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpirationTimeResponse
         */
        Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerFeatureStoreRuntimeRequest.BuilderImpl implements Builder {
        private String featureGroupName;

        private String recordIdentifierValueAsString;

        private List<String> featureNames = DefaultSdkAutoConstructList.getInstance();

        private String expirationTimeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordRequest model) {
            super(model);
            featureGroupName(model.featureGroupName);
            recordIdentifierValueAsString(model.recordIdentifierValueAsString);
            featureNames(model.featureNames);
            expirationTimeResponse(model.expirationTimeResponse);
        }

        public final String getFeatureGroupName() {
            return featureGroupName;
        }

        public final void setFeatureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
        }

        @Override
        public final Builder featureGroupName(String featureGroupName) {
            this.featureGroupName = featureGroupName;
            return this;
        }

        public final String getRecordIdentifierValueAsString() {
            return recordIdentifierValueAsString;
        }

        public final void setRecordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
        }

        @Override
        public final Builder recordIdentifierValueAsString(String recordIdentifierValueAsString) {
            this.recordIdentifierValueAsString = recordIdentifierValueAsString;
            return this;
        }

        public final Collection<String> getFeatureNames() {
            if (featureNames instanceof SdkAutoConstructList) {
                return null;
            }
            return featureNames;
        }

        public final void setFeatureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
        }

        @Override
        public final Builder featureNames(Collection<String> featureNames) {
            this.featureNames = FeatureNamesCopier.copy(featureNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureNames(String... featureNames) {
            featureNames(Arrays.asList(featureNames));
            return this;
        }

        public final String getExpirationTimeResponse() {
            return expirationTimeResponse;
        }

        public final void setExpirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
        }

        @Override
        public final Builder expirationTimeResponse(String expirationTimeResponse) {
            this.expirationTimeResponse = expirationTimeResponse;
            return this;
        }

        @Override
        public final Builder expirationTimeResponse(ExpirationTimeResponse expirationTimeResponse) {
            this.expirationTimeResponse(expirationTimeResponse == null ? null : expirationTimeResponse.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetRecordRequest build() {
            return new GetRecordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
