/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBucketsResponse extends S3Response implements
        ToCopyableBuilder<ListBucketsResponse.Builder, ListBucketsResponse> {
    private static final SdkField<List<Bucket>> BUCKETS_FIELD = SdkField
            .<List<Bucket>> builder(MarshallingType.LIST)
            .memberName("Buckets")
            .getter(getter(ListBucketsResponse::buckets))
            .setter(setter(Builder::buckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Buckets")
                    .unmarshallLocationName("Buckets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Bucket")
                            .memberFieldInfo(
                                    SdkField.<Bucket> builder(MarshallingType.SDK_POJO)
                                            .constructor(Bucket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Bucket").unmarshallLocationName("Bucket").build()).build())
                            .build()).build();

    private static final SdkField<Owner> OWNER_FIELD = SdkField
            .<Owner> builder(MarshallingType.SDK_POJO)
            .memberName("Owner")
            .getter(getter(ListBucketsResponse::owner))
            .setter(setter(Builder::owner))
            .constructor(Owner::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner")
                    .unmarshallLocationName("Owner").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContinuationToken")
            .getter(getter(ListBucketsResponse::continuationToken))
            .setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationToken")
                    .unmarshallLocationName("ContinuationToken").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Prefix")
            .getter(getter(ListBucketsResponse::prefix))
            .setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix")
                    .unmarshallLocationName("Prefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKETS_FIELD, OWNER_FIELD,
            CONTINUATION_TOKEN_FIELD, PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Bucket> buckets;

    private final Owner owner;

    private final String continuationToken;

    private final String prefix;

    private ListBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.buckets = builder.buckets;
        this.owner = builder.owner;
        this.continuationToken = builder.continuationToken;
        this.prefix = builder.prefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the Buckets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBuckets() {
        return buckets != null && !(buckets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of buckets owned by the requester.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBuckets} method.
     * </p>
     * 
     * @return The list of buckets owned by the requester.
     */
    public final List<Bucket> buckets() {
        return buckets;
    }

    /**
     * <p>
     * The owner of the buckets listed.
     * </p>
     * 
     * @return The owner of the buckets listed.
     */
    public final Owner owner() {
        return owner;
    }

    /**
     * <p>
     * <code>ContinuationToken</code> is included in the response when there are more buckets that can be listed with
     * pagination. The next <code>ListBuckets</code> request to Amazon S3 can be continued with this
     * <code>ContinuationToken</code>. <code>ContinuationToken</code> is obfuscated and is not a real bucket.
     * </p>
     * 
     * @return <code>ContinuationToken</code> is included in the response when there are more buckets that can be listed
     *         with pagination. The next <code>ListBuckets</code> request to Amazon S3 can be continued with this
     *         <code>ContinuationToken</code>. <code>ContinuationToken</code> is obfuscated and is not a real bucket.
     */
    public final String continuationToken() {
        return continuationToken;
    }

    /**
     * <p>
     * If <code>Prefix</code> was sent with the request, it is included in the response.
     * </p>
     * <p>
     * All bucket names in the response begin with the specified bucket name prefix.
     * </p>
     * 
     * @return If <code>Prefix</code> was sent with the request, it is included in the response.</p>
     *         <p>
     *         All bucket names in the response begin with the specified bucket name prefix.
     */
    public final String prefix() {
        return prefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasBuckets() ? buckets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBucketsResponse)) {
            return false;
        }
        ListBucketsResponse other = (ListBucketsResponse) obj;
        return hasBuckets() == other.hasBuckets() && Objects.equals(buckets(), other.buckets())
                && Objects.equals(owner(), other.owner()) && Objects.equals(continuationToken(), other.continuationToken())
                && Objects.equals(prefix(), other.prefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBucketsResponse").add("Buckets", hasBuckets() ? buckets() : null).add("Owner", owner())
                .add("ContinuationToken", continuationToken()).add("Prefix", prefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Buckets":
            return Optional.ofNullable(clazz.cast(buckets()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "ContinuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Buckets", BUCKETS_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("ContinuationToken", CONTINUATION_TOKEN_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBucketsResponse, T> g) {
        return obj -> g.apply((ListBucketsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo, CopyableBuilder<Builder, ListBucketsResponse> {
        /**
         * <p>
         * The list of buckets owned by the requester.
         * </p>
         * 
         * @param buckets
         *        The list of buckets owned by the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Collection<Bucket> buckets);

        /**
         * <p>
         * The list of buckets owned by the requester.
         * </p>
         * 
         * @param buckets
         *        The list of buckets owned by the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buckets(Bucket... buckets);

        /**
         * <p>
         * The list of buckets owned by the requester.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3.model.Bucket.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.s3.model.Bucket#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.s3.model.Bucket.Builder#build()}
         * is called immediately and its result is passed to {@link #buckets(List<Bucket>)}.
         * 
         * @param buckets
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.s3.model.Bucket.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #buckets(java.util.Collection<Bucket>)
         */
        Builder buckets(Consumer<Bucket.Builder>... buckets);

        /**
         * <p>
         * The owner of the buckets listed.
         * </p>
         * 
         * @param owner
         *        The owner of the buckets listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(Owner owner);

        /**
         * <p>
         * The owner of the buckets listed.
         * </p>
         * This is a convenience method that creates an instance of the {@link Owner.Builder} avoiding the need to
         * create one manually via {@link Owner#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Owner.Builder#build()} is called immediately and its result is
         * passed to {@link #owner(Owner)}.
         * 
         * @param owner
         *        a consumer that will call methods on {@link Owner.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #owner(Owner)
         */
        default Builder owner(Consumer<Owner.Builder> owner) {
            return owner(Owner.builder().applyMutation(owner).build());
        }

        /**
         * <p>
         * <code>ContinuationToken</code> is included in the response when there are more buckets that can be listed
         * with pagination. The next <code>ListBuckets</code> request to Amazon S3 can be continued with this
         * <code>ContinuationToken</code>. <code>ContinuationToken</code> is obfuscated and is not a real bucket.
         * </p>
         * 
         * @param continuationToken
         *        <code>ContinuationToken</code> is included in the response when there are more buckets that can be
         *        listed with pagination. The next <code>ListBuckets</code> request to Amazon S3 can be continued with
         *        this <code>ContinuationToken</code>. <code>ContinuationToken</code> is obfuscated and is not a real
         *        bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);

        /**
         * <p>
         * If <code>Prefix</code> was sent with the request, it is included in the response.
         * </p>
         * <p>
         * All bucket names in the response begin with the specified bucket name prefix.
         * </p>
         * 
         * @param prefix
         *        If <code>Prefix</code> was sent with the request, it is included in the response.</p>
         *        <p>
         *        All bucket names in the response begin with the specified bucket name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<Bucket> buckets = DefaultSdkAutoConstructList.getInstance();

        private Owner owner;

        private String continuationToken;

        private String prefix;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBucketsResponse model) {
            super(model);
            buckets(model.buckets);
            owner(model.owner);
            continuationToken(model.continuationToken);
            prefix(model.prefix);
        }

        public final List<Bucket.Builder> getBuckets() {
            List<Bucket.Builder> result = BucketsCopier.copyToBuilder(this.buckets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuckets(Collection<Bucket.BuilderImpl> buckets) {
            this.buckets = BucketsCopier.copyFromBuilder(buckets);
        }

        @Override
        public final Builder buckets(Collection<Bucket> buckets) {
            this.buckets = BucketsCopier.copy(buckets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Bucket... buckets) {
            buckets(Arrays.asList(buckets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buckets(Consumer<Bucket.Builder>... buckets) {
            buckets(Stream.of(buckets).map(c -> Bucket.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Owner.Builder getOwner() {
            return owner != null ? owner.toBuilder() : null;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        @Override
        public ListBucketsResponse build() {
            return new ListBucketsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
