/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest;
import software.amazon.awssdk.services.s3.model.VersioningConfiguration;

public class PutBucketVersioningRequestMarshaller
implements Marshaller<Request<PutBucketVersioningRequest>, PutBucketVersioningRequest> {
    public Request<PutBucketVersioningRequest> marshall(PutBucketVersioningRequest putBucketVersioningRequest) {
        if (putBucketVersioningRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketVersioningRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (putBucketVersioningRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString((String)putBucketVersioningRequest.contentMD5()));
        }
        if (putBucketVersioningRequest.mfa() != null) {
            request.addHeader("x-amz-mfa", StringUtils.fromString((String)putBucketVersioningRequest.mfa()));
        }
        String uriResourcePath = "/{Bucket}?versioning";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketVersioningRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            VersioningConfiguration versioningConfiguration = putBucketVersioningRequest.versioningConfiguration();
            if (versioningConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("VersioningConfiguration");
                if (versioningConfiguration.mfaDeleteString() != null) {
                    xmlWriter.startElement("MfaDelete").value(versioningConfiguration.mfaDeleteString()).endElement();
                }
                if (versioningConfiguration.statusString() != null) {
                    xmlWriter.startElement("Status").value(versioningConfiguration.statusString()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

