/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.MetricsAndOperator;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.transform.TagUnmarshaller;

public class MetricsAndOperatorUnmarshaller
implements Unmarshaller<MetricsAndOperator, StaxUnmarshallerContext> {
    private static final MetricsAndOperatorUnmarshaller INSTANCE = new MetricsAndOperatorUnmarshaller();

    public MetricsAndOperator unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricsAndOperator.Builder metricsAndOperator;
        block6: {
            metricsAndOperator = MetricsAndOperator.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    metricsAndOperator.tags(tags);
                    break block6;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Prefix", targetDepth)) {
                        metricsAndOperator.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Tag", targetDepth)) continue;
                    if (tags == null) {
                        tags = new ArrayList<Tag>();
                    }
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            metricsAndOperator.tags(tags);
        }
        return (MetricsAndOperator)metricsAndOperator.build();
    }

    public static MetricsAndOperatorUnmarshaller getInstance() {
        return INSTANCE;
    }
}

