/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.CommonPrefix;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Response;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.services.s3.transform.CommonPrefixUnmarshaller;
import software.amazon.awssdk.services.s3.transform.S3ObjectUnmarshaller;

public class ListObjectsV2ResponseUnmarshaller
implements Unmarshaller<ListObjectsV2Response, StaxUnmarshallerContext> {
    private static final ListObjectsV2ResponseUnmarshaller INSTANCE = new ListObjectsV2ResponseUnmarshaller();

    public ListObjectsV2Response unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectsV2Response.Builder listObjectsV2Response;
        block17: {
            listObjectsV2Response = ListObjectsV2Response.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<S3Object> contents = null;
            ArrayList<CommonPrefix> commonPrefixes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    listObjectsV2Response.contents(contents);
                    listObjectsV2Response.commonPrefixes(commonPrefixes);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("IsTruncated", targetDepth)) {
                        listObjectsV2Response.isTruncated(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Contents", targetDepth)) {
                        if (contents == null) {
                            contents = new ArrayList<S3Object>();
                        }
                        contents.add(S3ObjectUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Name", targetDepth)) {
                        listObjectsV2Response.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Prefix", targetDepth)) {
                        listObjectsV2Response.prefix(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Delimiter", targetDepth)) {
                        listObjectsV2Response.delimiter(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MaxKeys", targetDepth)) {
                        listObjectsV2Response.maxKeys(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CommonPrefixes", targetDepth)) {
                        if (commonPrefixes == null) {
                            commonPrefixes = new ArrayList<CommonPrefix>();
                        }
                        commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EncodingType", targetDepth)) {
                        listObjectsV2Response.encodingType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("KeyCount", targetDepth)) {
                        listObjectsV2Response.keyCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ContinuationToken", targetDepth)) {
                        listObjectsV2Response.continuationToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NextContinuationToken", targetDepth)) {
                        listObjectsV2Response.nextContinuationToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("StartAfter", targetDepth)) continue;
                    listObjectsV2Response.startAfter(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            listObjectsV2Response.contents(contents);
            listObjectsV2Response.commonPrefixes(commonPrefixes);
        }
        return (ListObjectsV2Response)((Object)listObjectsV2Response.build());
    }

    public static ListObjectsV2ResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

