/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.DeleteBucketAnalyticsConfigurationRequest;

public class DeleteBucketAnalyticsConfigurationRequestMarshaller
implements Marshaller<Request<DeleteBucketAnalyticsConfigurationRequest>, DeleteBucketAnalyticsConfigurationRequest> {
    public Request<DeleteBucketAnalyticsConfigurationRequest> marshall(DeleteBucketAnalyticsConfigurationRequest deleteBucketAnalyticsConfigurationRequest) {
        if (deleteBucketAnalyticsConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteBucketAnalyticsConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{Bucket}?analytics";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", deleteBucketAnalyticsConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (deleteBucketAnalyticsConfigurationRequest.id() != null) {
            request.addParameter("id", StringUtils.fromString((String)deleteBucketAnalyticsConfigurationRequest.id()));
        }
        return request;
    }
}

