/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.s3.model.Event;
import software.amazon.awssdk.services.s3.model.EventListCopier;
import software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class QueueConfiguration
implements ToCopyableBuilder<Builder, QueueConfiguration> {
    private final String id;
    private final String queueArn;
    private final List<String> events;
    private final NotificationConfigurationFilter filter;

    private QueueConfiguration(BuilderImpl builder) {
        this.id = builder.id;
        this.queueArn = builder.queueArn;
        this.events = builder.events;
        this.filter = builder.filter;
    }

    public String id() {
        return this.id;
    }

    public String queueArn() {
        return this.queueArn;
    }

    public List<Event> events() {
        return TypeConverter.convert(this.events, Event::fromValue);
    }

    public List<String> eventsStrings() {
        return this.events;
    }

    public NotificationConfigurationFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueConfiguration)) {
            return false;
        }
        QueueConfiguration other = (QueueConfiguration)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.queueArn(), other.queueArn()) && Objects.equals(this.eventsStrings(), other.eventsStrings()) && Objects.equals(this.filter(), other.filter());
    }

    public String toString() {
        return ToString.builder((String)"QueueConfiguration").add("Id", (Object)this.id()).add("QueueArn", (Object)this.queueArn()).add("Events", this.eventsStrings()).add("Filter", (Object)this.filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "QueueArn": {
                return Optional.of(clazz.cast(this.queueArn()));
            }
            case "Events": {
                return Optional.of(clazz.cast(this.eventsStrings()));
            }
            case "Filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String queueArn;
        private List<String> events;
        private NotificationConfigurationFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueConfiguration model) {
            this.id(model.id);
            this.queueArn(model.queueArn);
            this.events(model.events);
            this.filter(model.filter);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getQueueArn() {
            return this.queueArn;
        }

        @Override
        public final Builder queueArn(String queueArn) {
            this.queueArn = queueArn;
            return this;
        }

        public final void setQueueArn(String queueArn) {
            this.queueArn = queueArn;
        }

        public final Collection<String> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<String> events) {
            this.events = EventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(String ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        public final void setEvents(Collection<String> events) {
            this.events = EventListCopier.copy(events);
        }

        public final NotificationConfigurationFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(NotificationConfigurationFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(NotificationConfigurationFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public QueueConfiguration build() {
            return new QueueConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueueConfiguration> {
        public Builder id(String var1);

        public Builder queueArn(String var1);

        public Builder events(Collection<String> var1);

        public Builder events(String ... var1);

        public Builder filter(NotificationConfigurationFilter var1);

        default public Builder filter(Consumer<NotificationConfigurationFilter.Builder> filter) {
            return this.filter((NotificationConfigurationFilter)((NotificationConfigurationFilter.Builder)NotificationConfigurationFilter.builder().apply(filter)).build());
        }
    }
}

