/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Owner
implements ToCopyableBuilder<Builder, Owner> {
    private final String displayName;
    private final String id;

    private Owner(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.id = builder.id;
    }

    public String displayName() {
        return this.displayName;
    }

    public String id() {
        return this.id;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Owner)) {
            return false;
        }
        Owner other = (Owner)obj;
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.id(), other.id());
    }

    public String toString() {
        return ToString.builder((String)"Owner").add("DisplayName", (Object)this.displayName()).add("ID", (Object)this.id()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DisplayName": {
                return Optional.of(clazz.cast(this.displayName()));
            }
            case "ID": {
                return Optional.of(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String displayName;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(Owner model) {
            this.displayName(model.displayName);
            this.id(model.id);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getID() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setID(String id) {
            this.id = id;
        }

        public Owner build() {
            return new Owner(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Owner> {
        public Builder displayName(String var1);

        public Builder id(String var1);
    }
}

