/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LifecycleExpiration
implements ToCopyableBuilder<Builder, LifecycleExpiration> {
    private final Instant date;
    private final Integer days;
    private final Boolean expiredObjectDeleteMarker;

    private LifecycleExpiration(BuilderImpl builder) {
        this.date = builder.date;
        this.days = builder.days;
        this.expiredObjectDeleteMarker = builder.expiredObjectDeleteMarker;
    }

    public Instant date() {
        return this.date;
    }

    public Integer days() {
        return this.days;
    }

    public Boolean expiredObjectDeleteMarker() {
        return this.expiredObjectDeleteMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.date());
        hashCode = 31 * hashCode + Objects.hashCode(this.days());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiredObjectDeleteMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExpiration)) {
            return false;
        }
        LifecycleExpiration other = (LifecycleExpiration)obj;
        return Objects.equals(this.date(), other.date()) && Objects.equals(this.days(), other.days()) && Objects.equals(this.expiredObjectDeleteMarker(), other.expiredObjectDeleteMarker());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleExpiration").add("Date", (Object)this.date()).add("Days", (Object)this.days()).add("ExpiredObjectDeleteMarker", (Object)this.expiredObjectDeleteMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Date": {
                return Optional.of(clazz.cast(this.date()));
            }
            case "Days": {
                return Optional.of(clazz.cast(this.days()));
            }
            case "ExpiredObjectDeleteMarker": {
                return Optional.of(clazz.cast(this.expiredObjectDeleteMarker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant date;
        private Integer days;
        private Boolean expiredObjectDeleteMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExpiration model) {
            this.date(model.date);
            this.days(model.days);
            this.expiredObjectDeleteMarker(model.expiredObjectDeleteMarker);
        }

        public final Instant getDate() {
            return this.date;
        }

        @Override
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        public final Integer getDays() {
            return this.days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        public final Boolean getExpiredObjectDeleteMarker() {
            return this.expiredObjectDeleteMarker;
        }

        @Override
        public final Builder expiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
            return this;
        }

        public final void setExpiredObjectDeleteMarker(Boolean expiredObjectDeleteMarker) {
            this.expiredObjectDeleteMarker = expiredObjectDeleteMarker;
        }

        public LifecycleExpiration build() {
            return new LifecycleExpiration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LifecycleExpiration> {
        public Builder date(Instant var1);

        public Builder days(Integer var1);

        public Builder expiredObjectDeleteMarker(Boolean var1);
    }
}

