/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.MetadataCopier;
import software.amazon.awssdk.services.s3.model.ReplicationStatus;
import software.amazon.awssdk.services.s3.model.RequestCharged;
import software.amazon.awssdk.services.s3.model.S3Response;
import software.amazon.awssdk.services.s3.model.ServerSideEncryption;
import software.amazon.awssdk.services.s3.model.StorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetObjectResponse
extends S3Response
implements ToCopyableBuilder<Builder, GetObjectResponse> {
    private final Boolean deleteMarker;
    private final String acceptRanges;
    private final String expiration;
    private final String restore;
    private final Instant lastModified;
    private final Long contentLength;
    private final String eTag;
    private final Integer missingMeta;
    private final String versionId;
    private final String cacheControl;
    private final String contentDisposition;
    private final String contentEncoding;
    private final String contentLanguage;
    private final String contentRange;
    private final String contentType;
    private final Instant expires;
    private final String websiteRedirectLocation;
    private final String serverSideEncryption;
    private final Map<String, String> metadata;
    private final String sseCustomerAlgorithm;
    private final String sseCustomerKeyMD5;
    private final String ssekmsKeyId;
    private final String storageClass;
    private final String requestCharged;
    private final String replicationStatus;
    private final Integer partsCount;
    private final Integer tagCount;

    private GetObjectResponse(BuilderImpl builder) {
        super(builder);
        this.deleteMarker = builder.deleteMarker;
        this.acceptRanges = builder.acceptRanges;
        this.expiration = builder.expiration;
        this.restore = builder.restore;
        this.lastModified = builder.lastModified;
        this.contentLength = builder.contentLength;
        this.eTag = builder.eTag;
        this.missingMeta = builder.missingMeta;
        this.versionId = builder.versionId;
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.contentRange = builder.contentRange;
        this.contentType = builder.contentType;
        this.expires = builder.expires;
        this.websiteRedirectLocation = builder.websiteRedirectLocation;
        this.serverSideEncryption = builder.serverSideEncryption;
        this.metadata = builder.metadata;
        this.sseCustomerAlgorithm = builder.sseCustomerAlgorithm;
        this.sseCustomerKeyMD5 = builder.sseCustomerKeyMD5;
        this.ssekmsKeyId = builder.ssekmsKeyId;
        this.storageClass = builder.storageClass;
        this.requestCharged = builder.requestCharged;
        this.replicationStatus = builder.replicationStatus;
        this.partsCount = builder.partsCount;
        this.tagCount = builder.tagCount;
    }

    public Boolean deleteMarker() {
        return this.deleteMarker;
    }

    public String acceptRanges() {
        return this.acceptRanges;
    }

    public String expiration() {
        return this.expiration;
    }

    public String restore() {
        return this.restore;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer missingMeta() {
        return this.missingMeta;
    }

    public String versionId() {
        return this.versionId;
    }

    public String cacheControl() {
        return this.cacheControl;
    }

    public String contentDisposition() {
        return this.contentDisposition;
    }

    public String contentEncoding() {
        return this.contentEncoding;
    }

    public String contentLanguage() {
        return this.contentLanguage;
    }

    public String contentRange() {
        return this.contentRange;
    }

    public String contentType() {
        return this.contentType;
    }

    public Instant expires() {
        return this.expires;
    }

    public String websiteRedirectLocation() {
        return this.websiteRedirectLocation;
    }

    public ServerSideEncryption serverSideEncryption() {
        return ServerSideEncryption.fromValue(this.serverSideEncryption);
    }

    public String serverSideEncryptionString() {
        return this.serverSideEncryption;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String sseCustomerAlgorithm() {
        return this.sseCustomerAlgorithm;
    }

    public String sseCustomerKeyMD5() {
        return this.sseCustomerKeyMD5;
    }

    public String ssekmsKeyId() {
        return this.ssekmsKeyId;
    }

    public StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public String storageClassString() {
        return this.storageClass;
    }

    public RequestCharged requestCharged() {
        return RequestCharged.fromValue(this.requestCharged);
    }

    public String requestChargedString() {
        return this.requestCharged;
    }

    public ReplicationStatus replicationStatus() {
        return ReplicationStatus.fromValue(this.replicationStatus);
    }

    public String replicationStatusString() {
        return this.replicationStatus;
    }

    public Integer partsCount() {
        return this.partsCount;
    }

    public Integer tagCount() {
        return this.tagCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        hashCode = 31 * hashCode + Objects.hashCode(this.restore());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingMeta());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteRedirectLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseCustomerKeyMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssekmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestChargedString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectResponse)) {
            return false;
        }
        GetObjectResponse other = (GetObjectResponse)((Object)obj);
        return Objects.equals(this.deleteMarker(), other.deleteMarker()) && Objects.equals(this.acceptRanges(), other.acceptRanges()) && Objects.equals(this.expiration(), other.expiration()) && Objects.equals(this.restore(), other.restore()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.missingMeta(), other.missingMeta()) && Objects.equals(this.versionId(), other.versionId()) && Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.contentDisposition(), other.contentDisposition()) && Objects.equals(this.contentEncoding(), other.contentEncoding()) && Objects.equals(this.contentLanguage(), other.contentLanguage()) && Objects.equals(this.contentRange(), other.contentRange()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.websiteRedirectLocation(), other.websiteRedirectLocation()) && Objects.equals(this.serverSideEncryptionString(), other.serverSideEncryptionString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.sseCustomerAlgorithm(), other.sseCustomerAlgorithm()) && Objects.equals(this.sseCustomerKeyMD5(), other.sseCustomerKeyMD5()) && Objects.equals(this.ssekmsKeyId(), other.ssekmsKeyId()) && Objects.equals(this.storageClassString(), other.storageClassString()) && Objects.equals(this.requestChargedString(), other.requestChargedString()) && Objects.equals(this.replicationStatusString(), other.replicationStatusString()) && Objects.equals(this.partsCount(), other.partsCount()) && Objects.equals(this.tagCount(), other.tagCount());
    }

    public String toString() {
        return ToString.builder((String)"GetObjectResponse").add("DeleteMarker", (Object)this.deleteMarker()).add("AcceptRanges", (Object)this.acceptRanges()).add("Expiration", (Object)this.expiration()).add("Restore", (Object)this.restore()).add("LastModified", (Object)this.lastModified()).add("ContentLength", (Object)this.contentLength()).add("ETag", (Object)this.eTag()).add("MissingMeta", (Object)this.missingMeta()).add("VersionId", (Object)this.versionId()).add("CacheControl", (Object)this.cacheControl()).add("ContentDisposition", (Object)this.contentDisposition()).add("ContentEncoding", (Object)this.contentEncoding()).add("ContentLanguage", (Object)this.contentLanguage()).add("ContentRange", (Object)this.contentRange()).add("ContentType", (Object)this.contentType()).add("Expires", (Object)this.expires()).add("WebsiteRedirectLocation", (Object)this.websiteRedirectLocation()).add("ServerSideEncryption", (Object)this.serverSideEncryptionString()).add("Metadata", this.metadata()).add("SSECustomerAlgorithm", (Object)this.sseCustomerAlgorithm()).add("SSECustomerKeyMD5", (Object)this.sseCustomerKeyMD5()).add("SSEKMSKeyId", (Object)this.ssekmsKeyId()).add("StorageClass", (Object)this.storageClassString()).add("RequestCharged", (Object)this.requestChargedString()).add("ReplicationStatus", (Object)this.replicationStatusString()).add("PartsCount", (Object)this.partsCount()).add("TagCount", (Object)this.tagCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeleteMarker": {
                return Optional.of(clazz.cast(this.deleteMarker()));
            }
            case "AcceptRanges": {
                return Optional.of(clazz.cast(this.acceptRanges()));
            }
            case "Expiration": {
                return Optional.of(clazz.cast(this.expiration()));
            }
            case "Restore": {
                return Optional.of(clazz.cast(this.restore()));
            }
            case "LastModified": {
                return Optional.of(clazz.cast(this.lastModified()));
            }
            case "ContentLength": {
                return Optional.of(clazz.cast(this.contentLength()));
            }
            case "ETag": {
                return Optional.of(clazz.cast(this.eTag()));
            }
            case "MissingMeta": {
                return Optional.of(clazz.cast(this.missingMeta()));
            }
            case "VersionId": {
                return Optional.of(clazz.cast(this.versionId()));
            }
            case "CacheControl": {
                return Optional.of(clazz.cast(this.cacheControl()));
            }
            case "ContentDisposition": {
                return Optional.of(clazz.cast(this.contentDisposition()));
            }
            case "ContentEncoding": {
                return Optional.of(clazz.cast(this.contentEncoding()));
            }
            case "ContentLanguage": {
                return Optional.of(clazz.cast(this.contentLanguage()));
            }
            case "ContentRange": {
                return Optional.of(clazz.cast(this.contentRange()));
            }
            case "ContentType": {
                return Optional.of(clazz.cast(this.contentType()));
            }
            case "Expires": {
                return Optional.of(clazz.cast(this.expires()));
            }
            case "WebsiteRedirectLocation": {
                return Optional.of(clazz.cast(this.websiteRedirectLocation()));
            }
            case "ServerSideEncryption": {
                return Optional.of(clazz.cast(this.serverSideEncryptionString()));
            }
            case "Metadata": {
                return Optional.of(clazz.cast(this.metadata()));
            }
            case "SSECustomerAlgorithm": {
                return Optional.of(clazz.cast(this.sseCustomerAlgorithm()));
            }
            case "SSECustomerKeyMD5": {
                return Optional.of(clazz.cast(this.sseCustomerKeyMD5()));
            }
            case "SSEKMSKeyId": {
                return Optional.of(clazz.cast(this.ssekmsKeyId()));
            }
            case "StorageClass": {
                return Optional.of(clazz.cast(this.storageClassString()));
            }
            case "RequestCharged": {
                return Optional.of(clazz.cast(this.requestChargedString()));
            }
            case "ReplicationStatus": {
                return Optional.of(clazz.cast(this.replicationStatusString()));
            }
            case "PartsCount": {
                return Optional.of(clazz.cast(this.partsCount()));
            }
            case "TagCount": {
                return Optional.of(clazz.cast(this.tagCount()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends S3Response.BuilderImpl
    implements Builder {
        private Boolean deleteMarker;
        private String acceptRanges;
        private String expiration;
        private String restore;
        private Instant lastModified;
        private Long contentLength;
        private String eTag;
        private Integer missingMeta;
        private String versionId;
        private String cacheControl;
        private String contentDisposition;
        private String contentEncoding;
        private String contentLanguage;
        private String contentRange;
        private String contentType;
        private Instant expires;
        private String websiteRedirectLocation;
        private String serverSideEncryption;
        private Map<String, String> metadata;
        private String sseCustomerAlgorithm;
        private String sseCustomerKeyMD5;
        private String ssekmsKeyId;
        private String storageClass;
        private String requestCharged;
        private String replicationStatus;
        private Integer partsCount;
        private Integer tagCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectResponse model) {
            this.deleteMarker(model.deleteMarker);
            this.acceptRanges(model.acceptRanges);
            this.expiration(model.expiration);
            this.restore(model.restore);
            this.lastModified(model.lastModified);
            this.contentLength(model.contentLength);
            this.eTag(model.eTag);
            this.missingMeta(model.missingMeta);
            this.versionId(model.versionId);
            this.cacheControl(model.cacheControl);
            this.contentDisposition(model.contentDisposition);
            this.contentEncoding(model.contentEncoding);
            this.contentLanguage(model.contentLanguage);
            this.contentRange(model.contentRange);
            this.contentType(model.contentType);
            this.expires(model.expires);
            this.websiteRedirectLocation(model.websiteRedirectLocation);
            this.serverSideEncryption(model.serverSideEncryption);
            this.metadata(model.metadata);
            this.sseCustomerAlgorithm(model.sseCustomerAlgorithm);
            this.sseCustomerKeyMD5(model.sseCustomerKeyMD5);
            this.ssekmsKeyId(model.ssekmsKeyId);
            this.storageClass(model.storageClass);
            this.requestCharged(model.requestCharged);
            this.replicationStatus(model.replicationStatus);
            this.partsCount(model.partsCount);
            this.tagCount(model.tagCount);
        }

        public final Boolean getDeleteMarker() {
            return this.deleteMarker;
        }

        @Override
        public final Builder deleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
            return this;
        }

        public final void setDeleteMarker(Boolean deleteMarker) {
            this.deleteMarker = deleteMarker;
        }

        public final String getAcceptRanges() {
            return this.acceptRanges;
        }

        @Override
        public final Builder acceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
            return this;
        }

        public final void setAcceptRanges(String acceptRanges) {
            this.acceptRanges = acceptRanges;
        }

        public final String getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public final String getRestore() {
            return this.restore;
        }

        @Override
        public final Builder restore(String restore) {
            this.restore = restore;
            return this;
        }

        public final void setRestore(String restore) {
            this.restore = restore;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getETag() {
            return this.eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final Integer getMissingMeta() {
            return this.missingMeta;
        }

        @Override
        public final Builder missingMeta(Integer missingMeta) {
            this.missingMeta = missingMeta;
            return this;
        }

        public final void setMissingMeta(Integer missingMeta) {
            this.missingMeta = missingMeta;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return this.contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return this.contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final String getContentRange() {
            return this.contentRange;
        }

        @Override
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        public final String getContentType() {
            return this.contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Instant getExpires() {
            return this.expires;
        }

        @Override
        public final Builder expires(Instant expires) {
            this.expires = expires;
            return this;
        }

        public final void setExpires(Instant expires) {
            this.expires = expires;
        }

        public final String getWebsiteRedirectLocation() {
            return this.websiteRedirectLocation;
        }

        @Override
        public final Builder websiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
            return this;
        }

        public final void setWebsiteRedirectLocation(String websiteRedirectLocation) {
            this.websiteRedirectLocation = websiteRedirectLocation;
        }

        public final String getServerSideEncryption() {
            return this.serverSideEncryption;
        }

        @Override
        public final Builder serverSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
            return this;
        }

        @Override
        public final Builder serverSideEncryption(ServerSideEncryption serverSideEncryption) {
            this.serverSideEncryption(serverSideEncryption.toString());
            return this;
        }

        public final void setServerSideEncryption(String serverSideEncryption) {
            this.serverSideEncryption = serverSideEncryption;
        }

        public final Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        public final String getSSECustomerAlgorithm() {
            return this.sseCustomerAlgorithm;
        }

        @Override
        public final Builder sseCustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
            return this;
        }

        public final void setSSECustomerAlgorithm(String sseCustomerAlgorithm) {
            this.sseCustomerAlgorithm = sseCustomerAlgorithm;
        }

        public final String getSSECustomerKeyMD5() {
            return this.sseCustomerKeyMD5;
        }

        @Override
        public final Builder sseCustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
            return this;
        }

        public final void setSSECustomerKeyMD5(String sseCustomerKeyMD5) {
            this.sseCustomerKeyMD5 = sseCustomerKeyMD5;
        }

        public final String getSSEKMSKeyId() {
            return this.ssekmsKeyId;
        }

        @Override
        public final Builder ssekmsKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
            return this;
        }

        public final void setSSEKMSKeyId(String ssekmsKeyId) {
            this.ssekmsKeyId = ssekmsKeyId;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getRequestCharged() {
            return this.requestCharged;
        }

        @Override
        public final Builder requestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
            return this;
        }

        @Override
        public final Builder requestCharged(RequestCharged requestCharged) {
            this.requestCharged(requestCharged.toString());
            return this;
        }

        public final void setRequestCharged(String requestCharged) {
            this.requestCharged = requestCharged;
        }

        public final String getReplicationStatus() {
            return this.replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(ReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus.toString());
            return this;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        public final Integer getPartsCount() {
            return this.partsCount;
        }

        @Override
        public final Builder partsCount(Integer partsCount) {
            this.partsCount = partsCount;
            return this;
        }

        public final void setPartsCount(Integer partsCount) {
            this.partsCount = partsCount;
        }

        public final Integer getTagCount() {
            return this.tagCount;
        }

        @Override
        public final Builder tagCount(Integer tagCount) {
            this.tagCount = tagCount;
            return this;
        }

        public final void setTagCount(Integer tagCount) {
            this.tagCount = tagCount;
        }

        @Override
        public GetObjectResponse build() {
            return new GetObjectResponse(this);
        }
    }

    public static interface Builder
    extends S3Response.Builder,
    CopyableBuilder<Builder, GetObjectResponse> {
        public Builder deleteMarker(Boolean var1);

        public Builder acceptRanges(String var1);

        public Builder expiration(String var1);

        public Builder restore(String var1);

        public Builder lastModified(Instant var1);

        public Builder contentLength(Long var1);

        public Builder eTag(String var1);

        public Builder missingMeta(Integer var1);

        public Builder versionId(String var1);

        public Builder cacheControl(String var1);

        public Builder contentDisposition(String var1);

        public Builder contentEncoding(String var1);

        public Builder contentLanguage(String var1);

        public Builder contentRange(String var1);

        public Builder contentType(String var1);

        public Builder expires(Instant var1);

        public Builder websiteRedirectLocation(String var1);

        public Builder serverSideEncryption(String var1);

        public Builder serverSideEncryption(ServerSideEncryption var1);

        public Builder metadata(Map<String, String> var1);

        public Builder sseCustomerAlgorithm(String var1);

        public Builder sseCustomerKeyMD5(String var1);

        public Builder ssekmsKeyId(String var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder requestCharged(String var1);

        public Builder requestCharged(RequestCharged var1);

        public Builder replicationStatus(String var1);

        public Builder replicationStatus(ReplicationStatus var1);

        public Builder partsCount(Integer var1);

        public Builder tagCount(Integer var1);
    }
}

