/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.LambdaFunctionConfiguration;
import software.amazon.awssdk.services.s3.model.NotificationConfiguration;
import software.amazon.awssdk.services.s3.model.QueueConfiguration;
import software.amazon.awssdk.services.s3.model.TopicConfiguration;
import software.amazon.awssdk.services.s3.transform.LambdaFunctionConfigurationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.QueueConfigurationUnmarshaller;
import software.amazon.awssdk.services.s3.transform.TopicConfigurationUnmarshaller;

public class NotificationConfigurationUnmarshaller
implements Unmarshaller<NotificationConfiguration, StaxUnmarshallerContext> {
    private static final NotificationConfigurationUnmarshaller INSTANCE = new NotificationConfigurationUnmarshaller();

    public NotificationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        NotificationConfiguration.Builder notificationConfiguration;
        block9: {
            notificationConfiguration = NotificationConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<TopicConfiguration> topicConfigurations = null;
            ArrayList<QueueConfiguration> queueConfigurations = null;
            ArrayList<LambdaFunctionConfiguration> lambdaFunctionConfigurations = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    notificationConfiguration.topicConfigurations(topicConfigurations);
                    notificationConfiguration.queueConfigurations(queueConfigurations);
                    notificationConfiguration.lambdaFunctionConfigurations(lambdaFunctionConfigurations);
                    break block9;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("TopicConfiguration", targetDepth)) {
                        if (topicConfigurations == null) {
                            topicConfigurations = new ArrayList<TopicConfiguration>();
                        }
                        topicConfigurations.add(TopicConfigurationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("QueueConfiguration", targetDepth)) {
                        if (queueConfigurations == null) {
                            queueConfigurations = new ArrayList<QueueConfiguration>();
                        }
                        queueConfigurations.add(QueueConfigurationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("CloudFunctionConfiguration", targetDepth)) continue;
                    if (lambdaFunctionConfigurations == null) {
                        lambdaFunctionConfigurations = new ArrayList<LambdaFunctionConfiguration>();
                    }
                    lambdaFunctionConfigurations.add(LambdaFunctionConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            notificationConfiguration.topicConfigurations(topicConfigurations);
            notificationConfiguration.queueConfigurations(queueConfigurations);
            notificationConfiguration.lambdaFunctionConfigurations(lambdaFunctionConfigurations);
        }
        return (NotificationConfiguration)notificationConfiguration.build();
    }

    public static NotificationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

