/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.ListBucketInventoryConfigurationsRequest;

public class ListBucketInventoryConfigurationsRequestMarshaller
implements Marshaller<Request<ListBucketInventoryConfigurationsRequest>, ListBucketInventoryConfigurationsRequest> {
    public Request<ListBucketInventoryConfigurationsRequest> marshall(ListBucketInventoryConfigurationsRequest listBucketInventoryConfigurationsRequest) {
        if (listBucketInventoryConfigurationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)listBucketInventoryConfigurationsRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", listBucketInventoryConfigurationsRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (listBucketInventoryConfigurationsRequest.continuationToken() != null) {
            request.addParameter("continuation-token", StringUtils.fromString((String)listBucketInventoryConfigurationsRequest.continuationToken()));
        }
        return request;
    }
}

