/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.s3.model.DeleteObjectsResponse;
import software.amazon.awssdk.services.s3.model.DeletedObject;
import software.amazon.awssdk.services.s3.model.S3Error;
import software.amazon.awssdk.services.s3.transform.DeletedObjectUnmarshaller;
import software.amazon.awssdk.services.s3.transform.S3ErrorUnmarshaller;

public class DeleteObjectsResponseUnmarshaller
implements Unmarshaller<DeleteObjectsResponse, StaxUnmarshallerContext> {
    private static final DeleteObjectsResponseUnmarshaller INSTANCE = new DeleteObjectsResponseUnmarshaller();

    public DeleteObjectsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DeleteObjectsResponse.Builder deleteObjectsResponse;
        block8: {
            deleteObjectsResponse = DeleteObjectsResponse.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            if (context.isStartOfDocument()) {
                context.setCurrentHeader("x-amz-request-charged");
                deleteObjectsResponse.requestCharged(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
            }
            ArrayList<DeletedObject> deleted = null;
            ArrayList<S3Error> errors = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    deleteObjectsResponse.deleted(deleted);
                    deleteObjectsResponse.errors(errors);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Deleted", targetDepth)) {
                        if (deleted == null) {
                            deleted = new ArrayList<DeletedObject>();
                        }
                        deleted.add(DeletedObjectUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Error", targetDepth)) continue;
                    if (errors == null) {
                        errors = new ArrayList<S3Error>();
                    }
                    errors.add(S3ErrorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            deleteObjectsResponse.deleted(deleted);
            deleteObjectsResponse.errors(errors);
        }
        return (DeleteObjectsResponse)((Object)deleteObjectsResponse.build());
    }

    public static DeleteObjectsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

