/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshallers;
import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.core.util.XmlWriter;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public class CreateBucketRequestMarshaller
implements Marshaller<Request<CreateBucketRequest>, CreateBucketRequest> {
    public Request<CreateBucketRequest> marshall(CreateBucketRequest createBucketRequest) {
        if (createBucketRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createBucketRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        if (createBucketRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString((String)createBucketRequest.aclString()));
        }
        if (createBucketRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString((String)createBucketRequest.grantFullControl()));
        }
        if (createBucketRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString((String)createBucketRequest.grantRead()));
        }
        if (createBucketRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString((String)createBucketRequest.grantReadACP()));
        }
        if (createBucketRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString((String)createBucketRequest.grantWrite()));
        }
        if (createBucketRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString((String)createBucketRequest.grantWriteACP()));
        }
        String uriResourcePath = "/{Bucket}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Bucket", createBucketRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            CreateBucketConfiguration createBucketConfiguration = createBucketRequest.createBucketConfiguration();
            if (createBucketConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("CreateBucketConfiguration");
                if (createBucketConfiguration.locationConstraintString() != null) {
                    xmlWriter.startElement("LocationConstraint").value(createBucketConfiguration.locationConstraintString()).endElement();
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }
        return request;
    }
}

