/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.BucketVersioningStatus;
import software.amazon.awssdk.services.s3.model.MFADelete;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VersioningConfiguration
implements ToCopyableBuilder<Builder, VersioningConfiguration> {
    private final String mfaDelete;
    private final String status;

    private VersioningConfiguration(BuilderImpl builder) {
        this.mfaDelete = builder.mfaDelete;
        this.status = builder.status;
    }

    public MFADelete mfaDelete() {
        return MFADelete.fromValue(this.mfaDelete);
    }

    public String mfaDeleteString() {
        return this.mfaDelete;
    }

    public BucketVersioningStatus status() {
        return BucketVersioningStatus.fromValue(this.status);
    }

    public String statusString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mfaDeleteString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersioningConfiguration)) {
            return false;
        }
        VersioningConfiguration other = (VersioningConfiguration)obj;
        return Objects.equals(this.mfaDeleteString(), other.mfaDeleteString()) && Objects.equals(this.statusString(), other.statusString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.mfaDeleteString() != null) {
            sb.append("MFADelete: ").append(this.mfaDeleteString()).append(",");
        }
        if (this.statusString() != null) {
            sb.append("Status: ").append(this.statusString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MFADelete": {
                return Optional.of(clazz.cast(this.mfaDeleteString()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.statusString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String mfaDelete;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VersioningConfiguration model) {
            this.mfaDelete(model.mfaDelete);
            this.status(model.status);
        }

        public final String getMFADelete() {
            return this.mfaDelete;
        }

        @Override
        public final Builder mfaDelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
            return this;
        }

        @Override
        public final Builder mfaDelete(MFADelete mfaDelete) {
            this.mfaDelete(mfaDelete.toString());
            return this;
        }

        public final void setMFADelete(String mfaDelete) {
            this.mfaDelete = mfaDelete;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BucketVersioningStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public VersioningConfiguration build() {
            return new VersioningConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VersioningConfiguration> {
        public Builder mfaDelete(String var1);

        public Builder mfaDelete(MFADelete var1);

        public Builder status(String var1);

        public Builder status(BucketVersioningStatus var1);
    }
}

