/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.s3.model.Payer;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RequestPaymentConfiguration
implements ToCopyableBuilder<Builder, RequestPaymentConfiguration> {
    private final String payer;

    private RequestPaymentConfiguration(BuilderImpl builder) {
        this.payer = builder.payer;
    }

    public Payer payer() {
        return Payer.fromValue(this.payer);
    }

    public String payerString() {
        return this.payer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payerString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestPaymentConfiguration)) {
            return false;
        }
        RequestPaymentConfiguration other = (RequestPaymentConfiguration)obj;
        return Objects.equals(this.payerString(), other.payerString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.payerString() != null) {
            sb.append("Payer: ").append(this.payerString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Payer": {
                return Optional.of(clazz.cast(this.payerString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String payer;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestPaymentConfiguration model) {
            this.payer(model.payer);
        }

        public final String getPayer() {
            return this.payer;
        }

        @Override
        public final Builder payer(String payer) {
            this.payer = payer;
            return this;
        }

        @Override
        public final Builder payer(Payer payer) {
            this.payer(payer.toString());
            return this;
        }

        public final void setPayer(String payer) {
            this.payer = payer;
        }

        public RequestPaymentConfiguration build() {
            return new RequestPaymentConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RequestPaymentConfiguration> {
        public Builder payer(String var1);

        public Builder payer(Payer var1);
    }
}

