/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.core.auth.Aws4Signer;
import software.amazon.awssdk.core.auth.internal.Aws4SignerRequestParams;
import software.amazon.awssdk.core.exception.ResetException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.services.s3.auth.AwsChunkedEncodingInputStream;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Validate;

public class AwsS3V4Signer
extends Aws4Signer {
    private static final String CONTENT_SHA_256 = "STREAMING-AWS4-HMAC-SHA256-PAYLOAD";
    private static final String UNSIGNED_PAYLOAD = "UNSIGNED-PAYLOAD";
    private static final String CONTENT_LENGTH = "Content-Length";
    private Boolean disableChunkedEncoding;
    private Boolean enablePayloadSigning;

    public AwsS3V4Signer() {
        super(false);
    }

    protected void processRequestPayload(SdkHttpFullRequest.Builder requestBuilder, byte[] signature, byte[] signingKey, Aws4SignerRequestParams signerRequestParams) {
        if (this.useChunkEncoding(signerRequestParams)) {
            AwsChunkedEncodingInputStream chunkEncodededStream = new AwsChunkedEncodingInputStream(signerRequestParams.httpRequest().content(), signingKey, signerRequestParams.getFormattedSigningDateTime(), signerRequestParams.getScope(), BinaryUtils.toHex((byte[])signature), this);
            requestBuilder.content((InputStream)((Object)chunkEncodededStream));
        }
    }

    protected String calculateContentHashPresign(Aws4SignerRequestParams signerRequestParams, SdkHttpFullRequest.Builder mutableRequest) {
        return UNSIGNED_PAYLOAD;
    }

    protected String calculateContentHash(Aws4SignerRequestParams signerRequestParams, SdkHttpFullRequest.Builder mutableRequest) {
        mutableRequest.header("x-amz-content-sha256", "required");
        SdkHttpFullRequest.Builder requestToSign = signerRequestParams.httpRequest();
        if (this.isPayloadSigningEnabled(requestToSign)) {
            if (this.useChunkEncoding(signerRequestParams)) {
                long originalContentLength;
                String contentLength = requestToSign.firstMatchingHeader(CONTENT_LENGTH).orElse(null);
                if (contentLength != null) {
                    originalContentLength = Long.parseLong(contentLength);
                } else {
                    try {
                        originalContentLength = AwsS3V4Signer.getContentLength(signerRequestParams);
                    }
                    catch (IOException e) {
                        throw new SdkClientException("Cannot get the content-length of the request content.", (Throwable)e);
                    }
                }
                mutableRequest.header("x-amz-decoded-content-length", Long.toString(originalContentLength));
                mutableRequest.header(CONTENT_LENGTH, Long.toString(AwsChunkedEncodingInputStream.calculateStreamContentLength(originalContentLength)));
                return CONTENT_SHA_256;
            }
            return super.calculateContentHash(signerRequestParams, mutableRequest);
        }
        return UNSIGNED_PAYLOAD;
    }

    private boolean useChunkEncoding(Aws4SignerRequestParams signerRequestParams) {
        if (!this.isPayloadSigningEnabled(signerRequestParams.httpRequest()) || this.isChunkedEncodingDisabled()) {
            return false;
        }
        return signerRequestParams.originalRequest() instanceof PutObjectRequest || signerRequestParams.originalRequest() instanceof UploadPartRequest;
    }

    private boolean isChunkedEncodingDisabled() {
        return this.disableChunkedEncoding != null && this.disableChunkedEncoding != false;
    }

    private boolean isPayloadSigningEnabled(SdkHttpFullRequest.Builder request) {
        if (!request.protocol().equals("https")) {
            return true;
        }
        return this.enablePayloadSigning != null && this.enablePayloadSigning != false;
    }

    private static long getContentLength(Aws4SignerRequestParams signerParams) throws IOException {
        int read;
        InputStream content = signerParams.httpRequest().content();
        Validate.validState((boolean)content.markSupported(), (String)"Request input stream must have been made mark-and-resettable", (Object[])new Object[0]);
        long contentLength = 0L;
        byte[] tmp = new byte[4096];
        content.mark(AwsS3V4Signer.getReadLimit((Aws4SignerRequestParams)signerParams));
        while ((read = content.read(tmp)) != -1) {
            contentLength += (long)read;
        }
        try {
            content.reset();
        }
        catch (IOException ex) {
            throw new ResetException("Failed to reset the input stream", (Throwable)ex);
        }
        return contentLength;
    }

    @ReviewBeforeRelease(value="Create a builder for signers and set this in it. Also currently unexercised")
    public void setDisableChunkedEncoding(boolean disableChunkedEncoding) {
        this.disableChunkedEncoding = disableChunkedEncoding;
    }

    @ReviewBeforeRelease(value="Create a builder for signers and set this in it. Also currently unexercised.")
    public void setEnablePayloadSigning(boolean enablePayloadSigning) {
        this.enablePayloadSigning = enablePayloadSigning;
    }
}

