/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.Md5Utils;

/**
 * PutBucketPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutBucketPolicyRequestMarshaller implements Marshaller<Request<PutBucketPolicyRequest>, PutBucketPolicyRequest> {

    public Request<PutBucketPolicyRequest> marshall(PutBucketPolicyRequest putBucketPolicyRequest) {

        if (putBucketPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutBucketPolicyRequest> request = new DefaultRequest<PutBucketPolicyRequest>(putBucketPolicyRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putBucketPolicyRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putBucketPolicyRequest.contentMD5()));
        }

        String uriResourcePath = "/{Bucket}?policy";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putBucketPolicyRequest.bucket());
        request.setResourcePath(uriResourcePath);

        String policy = putBucketPolicyRequest.policy();
        if (policy != null) {
            byte[] content = policy.getBytes(StandardCharsets.UTF_8);
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-MD5")) {
                request.addHeader("Content-MD5", Md5Utils.md5AsBase64(content));
            }
        }

        return request;
    }

}