/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ObjectVersion StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ObjectVersionUnmarshaller implements Unmarshaller<ObjectVersion, StaxUnmarshallerContext> {

    public ObjectVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        ObjectVersion.Builder objectVersion = ObjectVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ETag", targetDepth)) {
                    objectVersion.eTag(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Size", targetDepth)) {
                    objectVersion.size(LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StorageClass", targetDepth)) {
                    objectVersion.storageClass(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Key", targetDepth)) {
                    objectVersion.key(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("VersionId", targetDepth)) {
                    objectVersion.versionId(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsLatest", targetDepth)) {
                    objectVersion.isLatest(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("LastModified", targetDepth)) {
                    objectVersion.lastModified(InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Owner", targetDepth)) {
                    objectVersion.owner(OwnerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return objectVersion.build();
    }

    private static final ObjectVersionUnmarshaller INSTANCE = new ObjectVersionUnmarshaller();

    public static ObjectVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}
