/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListBucketInventoryConfigurationsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListBucketInventoryConfigurationsResponseUnmarshaller implements
        Unmarshaller<ListBucketInventoryConfigurationsResponse, StaxUnmarshallerContext> {

    public ListBucketInventoryConfigurationsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListBucketInventoryConfigurationsResponse.Builder listBucketInventoryConfigurationsResponse = ListBucketInventoryConfigurationsResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<InventoryConfiguration> inventoryConfigurationList = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listBucketInventoryConfigurationsResponse.inventoryConfigurationList(inventoryConfigurationList);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("ContinuationToken", targetDepth)) {
                    listBucketInventoryConfigurationsResponse.continuationToken(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("InventoryConfiguration", targetDepth)) {
                    if (inventoryConfigurationList == null) {
                        inventoryConfigurationList = new ArrayList<>();
                    }
                    inventoryConfigurationList.add(InventoryConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listBucketInventoryConfigurationsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextContinuationToken", targetDepth)) {
                    listBucketInventoryConfigurationsResponse.nextContinuationToken(StringUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listBucketInventoryConfigurationsResponse.inventoryConfigurationList(inventoryConfigurationList);
                    break;
                }
            }
        }
        return listBucketInventoryConfigurationsResponse.build();
    }

    private static final ListBucketInventoryConfigurationsResponseUnmarshaller INSTANCE = new ListBucketInventoryConfigurationsResponseUnmarshaller();

    public static ListBucketInventoryConfigurationsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
